#!/bin/bash

source ~/.bashrc
conda activate mace-update-v5

PREFIX=/data/cluster_name/scratch/$(whoami)/projects/MACE-Update


CUDA_VISIBLE_DEVICES=$1
ALGO_NAME=$2


## CELEBRITY
# CHANGE="baseline"
# ORIG_TASK="celebrity"
# FINETUNE_ALGO="lora"
# FINETUNE_TASK="celebrity"
# FINETUNE_CONFIG="celebrity_random_concepts_seed0"
# PORT_NUMBER=20000
# METRIC="FID"

# for NUM_CELEBS in 10
# do
#     ORIG_CONFIG="erase_cele_${NUM_CELEBS}"
#     PROMPTS_CSV="coco_5k"
#     for RANDOM_SEED in {0..0}
#     do
#         echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
#         $PREFIX/evaluation/compute_metrics_finetune.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
#         PORT_NUMBER=$((PORT_NUMBER+1))
#     done
# done

CHANGE="car_reg"
ORIG_TASK="celebrity"
FINETUNE_ALGO="lora"
FINETUNE_TASK="celebrity"
FINETUNE_CONFIG="celebrity_random_concepts_seed0"
PORT_NUMBER=20000
METRIC="GCD"

for NUM_CELEBS in 10
do
    ORIG_CONFIG="erase_cele_${NUM_CELEBS}"
    PROMPTS_CSV="celebrity_${NUM_CELEBS}_concepts"
    for REG in 0.001 0.01
    do
        CHANGE="car_reg=${REG}"
        for RANDOM_SEED in {0..2}
        do
            echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
            $PREFIX/evaluation/compute_metrics_finetune_new.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
            PORT_NUMBER=$((PORT_NUMBER+1))
        done
    done
done

CHANGE="car_reg"
ORIG_TASK="art"
FINETUNE_ALGO="lora"
FINETUNE_TASK="art"
FINETUNE_CONFIG="art_random_concepts_seed0"
PORT_NUMBER=20000
METRIC="clip_score"

for NUM_CELEBS in 100
do
    ORIG_CONFIG="erase_art_${NUM_CELEBS}"
    PROMPTS_CSV="art_${NUM_CELEBS}_concepts"
    for REG in 0.001 0.01
    do
        CHANGE="car_reg=${REG}"
        for RANDOM_SEED in {0..2}
        do
            echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
            $PREFIX/evaluation/compute_metrics_finetune_new.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
            PORT_NUMBER=$((PORT_NUMBER+1))
        done
    done
done

CHANGE="car_reg"
ORIG_TASK="object"
FINETUNE_ALGO="lora"
FINETUNE_TASK="object"
FINETUNE_CONFIG="object_random_concepts_seed0"
PORT_NUMBER=20000
METRIC="clip_acc"

for NUM_CELEBS in ship
do
    ORIG_CONFIG="erase_${NUM_CELEBS}"
    PROMPTS_CSV="object_${NUM_CELEBS}_concepts"
    for REG in 0.001 0.01
    do
        CHANGE="car_reg=${REG}"
        for RANDOM_SEED in {0..2}
        do
            echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
            $PREFIX/evaluation/compute_metrics_finetune_new.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
            PORT_NUMBER=$((PORT_NUMBER+1))
        done
    done
done

# CHANGE="baseline"
# ORIG_TASK="celebrity"
# FINETUNE_ALGO="full"
# FINETUNE_TASK="celebrity"
# FINETUNE_CONFIG="celebrity_random_concepts_seed0"
# PORT_NUMBER=20000
# METRIC="FID"

# for NUM_CELEBS in 10
# do
#     ORIG_CONFIG="erase_cele_${NUM_CELEBS}"
#     PROMPTS_CSV="coco_5k"
#     for RANDOM_SEED in {0..0}
#     do
#         echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
#         $PREFIX/evaluation/compute_metrics_finetune.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
#         PORT_NUMBER=$((PORT_NUMBER+1))
#     done
# done

# CHANGE="baseline"
# ORIG_TASK="celebrity"
# FINETUNE_ALGO="lora"
# FINETUNE_TASK="celebrity"
# PORT_NUMBER=20000
# METRIC="FID"

# for NUM_CELEBS in 10
# do
#     for FINETUNE_CONFIG in celebrity_10_clip_0 celebrity_10_clip_1 celebrity_10_clip_2
#     do
#         ORIG_CONFIG="erase_cele_${NUM_CELEBS}"
#         PROMPTS_CSV="coco_5k"
#         for RANDOM_SEED in {0..0}
#         do
#             echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
#             $PREFIX/evaluation/compute_metrics_finetune.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
#             PORT_NUMBER=$((PORT_NUMBER+1))
#         done
#     done
# done

# CHANGE="baseline"
# ORIG_TASK="celebrity"
# FINETUNE_ALGO="lora"
# FINETUNE_TASK="art"
# FINETUNE_CONFIG="art_random_concepts_seed0"
# PORT_NUMBER=20000
# METRIC="FID"

# for NUM_CELEBS in 10
# do
#     ORIG_CONFIG="erase_cele_${NUM_CELEBS}"
#     PROMPTS_CSV="coco_5k"
#     for RANDOM_SEED in {0..0}
#     do
#         echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
#         $PREFIX/evaluation/compute_metrics_finetune.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
#         PORT_NUMBER=$((PORT_NUMBER+1))
#     done
# done

# CHANGE="baseline"
# ORIG_TASK="celebrity"
# FINETUNE_ALGO="lora"
# FINETUNE_TASK="object"
# FINETUNE_CONFIG="object_random_concepts_seed0"
# PORT_NUMBER=20000
# METRIC="FID"

# for NUM_CELEBS in 10
# do
#     ORIG_CONFIG="erase_cele_${NUM_CELEBS}"
#     PROMPTS_CSV="coco_5k"
#     for RANDOM_SEED in {0..0}
#     do
#         echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
#         $PREFIX/evaluation/compute_metrics_finetune.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
#         PORT_NUMBER=$((PORT_NUMBER+1))
#     done
# done

# ## CELEBRITY
# CHANGE="baseline"
# ORIG_TASK="art"
# FINETUNE_ALGO="lora"
# FINETUNE_TASK="art"
# FINETUNE_CONFIG="art_random_concepts_seed0"
# PORT_NUMBER=20000
# METRIC="FID"

# for NUM_CELEBS in 100
# do
#     ORIG_CONFIG="erase_art_${NUM_CELEBS}"
#     PROMPTS_CSV="coco_5k"
#     for RANDOM_SEED in {0..0}
#     do
#         echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
#         $PREFIX/evaluation/compute_metrics_finetune.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
#         PORT_NUMBER=$((PORT_NUMBER+1))
#     done
# done

# CHANGE="car_reg"
# ORIG_TASK="art"
# FINETUNE_ALGO="lora"
# FINETUNE_TASK="art"
# FINETUNE_CONFIG="art_random_concepts_seed0"
# PORT_NUMBER=20000
# METRIC="FID"

# for NUM_CELEBS in 100
# do
#     ORIG_CONFIG="erase_art_${NUM_CELEBS}"
#     PROMPTS_CSV="coco_5k"
#     for REG in 0 0.1 1
#     do
#         CHANGE="car_reg=${REG}"
#         for RANDOM_SEED in {0..0}
#         do
#             echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
#             $PREFIX/evaluation/compute_metrics_finetune.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
#             PORT_NUMBER=$((PORT_NUMBER+1))
#         done
#     done
# done

# CHANGE="baseline"
# ORIG_TASK="art"
# FINETUNE_ALGO="full"
# FINETUNE_TASK="art"
# FINETUNE_CONFIG="art_random_concepts_seed0"
# PORT_NUMBER=20000
# METRIC="FID"

# for NUM_CELEBS in 100
# do
#     ORIG_CONFIG="erase_art_${NUM_CELEBS}"
#     PROMPTS_CSV="coco_5k"
#     for RANDOM_SEED in {0..0}
#     do
#         echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
#         $PREFIX/evaluation/compute_metrics_finetune.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
#         PORT_NUMBER=$((PORT_NUMBER+1))
#     done
# done

# CHANGE="baseline"
# ORIG_TASK="art"
# FINETUNE_ALGO="lora"
# FINETUNE_TASK="art"
# PORT_NUMBER=20000
# METRIC="FID"

# for NUM_CELEBS in 100
# do
#     for FINETUNE_CONFIG in art_100_clip_mean_0 art_100_clip_mean_1 art_100_clip_mean_2 art_100_clip_mean_3
#     do
#         ORIG_CONFIG="erase_cele_${NUM_CELEBS}"
#         PROMPTS_CSV="coco_5k"
#         for RANDOM_SEED in {0..0}
#         do
#             echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
#             $PREFIX/evaluation/compute_metrics_finetune.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
#             PORT_NUMBER=$((PORT_NUMBER+1))
#         done
#     done
# done

# CHANGE="baseline"
# ORIG_TASK="art"
# FINETUNE_ALGO="lora"
# FINETUNE_TASK="celebrity"
# FINETUNE_CONFIG="celebrity_random_concepts_seed0"
# PORT_NUMBER=20000
# METRIC="FID"

# for NUM_CELEBS in 100
# do
#     ORIG_CONFIG="erase_art_${NUM_CELEBS}"
#     PROMPTS_CSV="coco_5k"
#     for RANDOM_SEED in {0..0}
#     do
#         echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
#         $PREFIX/evaluation/compute_metrics_finetune.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
#         PORT_NUMBER=$((PORT_NUMBER+1))
#     done
# done

# CHANGE="baseline"
# ORIG_TASK="art"
# FINETUNE_ALGO="lora"
# FINETUNE_TASK="object"
# FINETUNE_CONFIG="object_random_concepts_seed0"
# PORT_NUMBER=20000
# METRIC="FID"

# for NUM_CELEBS in 100
# do
#     ORIG_CONFIG="erase_art_${NUM_CELEBS}"
#     PROMPTS_CSV="coco_5k"
#     for RANDOM_SEED in {0..0}
#     do
#         echo compute_metrics_${ALGO_NAME}_${CHANGE}_${ORIG_TASK}_${ORIG_CONFIG}_${PROMPTS_CSV}_${METRIC}_${RANDOM_SEED}
#         $PREFIX/evaluation/compute_metrics_finetune.sh $CUDA_VISIBLE_DEVICES $ALGO_NAME $CHANGE $ORIG_TASK $ORIG_CONFIG $FINETUNE_ALGO $FINETUNE_TASK $FINETUNE_CONFIG $PORT_NUMBER $PROMPTS_CSV $METRIC $RANDOM_SEED
#         PORT_NUMBER=$((PORT_NUMBER+1))
#     done
# done