#!/bin/bash

. /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/slurm/scripts/prelude.sh

ALGO_NAME=$2
CHANGE=$3
TASK=$4
CONFIG=$5
PORT_NUMBER=$6
PROMPTS_CSV=$7
RANDOM_SEED=$8

mkdir $PREFIX_SCRATCH/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}
cp /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/tasks/${TASK}/${PROMPTS_CSV}.csv /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV}/prompts.csv 

CUDA_VISIBLE_DEVICES=$1 accelerate launch \
          --multi_gpu --num_processes=2 --main_process_port $PORT_NUMBER \
          $PREFIX/inference/sample_images_from_csv.py \
          --prompts_path /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/tasks/${TASK}/${PROMPTS_CSV}.csv \
          --save_path /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/inference/${PROMPTS_CSV} \
          --model_name /data/cluster_name/scratch/$(whoami)/projects/MACE-Update/experiments/${ALGO_NAME}/${CHANGE}_${TASK}_${CONFIG}/${RANDOM_SEED}/LoRA_fusion_model/ \
          --step 2