# 3D Master Face Generation

As our project is a systematic engineering to build upon several individual projects (e.g. 2D and 3D Face Recognition Systems, .etc), the codebase is a bit large and need to be refined. 

We first put this draft readme file to share the link and dataset of libraries we employed in implementation.

We also put partial core code regarding the LVE algorithm for reference.

The full code will be released after the paper decision.

## Dataset
- [BU-3DFE](https://www.cs.binghamton.edu/~lijun/Research/3DFE/3DFE_Analysis.html)
- [Headspace](https://www-users.york.ac.uk/~np7/research/Headspace/)
- [FaceScape](https://github.com/zhuhao-nju/facescape)
- [Texas3D](https://live.ece.utexas.edu/research/texas3dfr/)

We utilize the FaceScape codebase to:
1. Generate synthesized faces to fine-tune IResNet;
2. Using its code to render the meshes to RGB-D dataset.

## Libraries

### 2D Face Recognition System Related
- [FaceNet-Pytorch](https://github.com/timesler/facenet-pytorch)
- [AdaFace](https://github.com/mk-minchul/AdaFace)
- [BiSeNet](https://github.com/zllrunning/face-parsing.PyTorch)

### 3D Face Recoginition System
- [Led3D](https://github.com/muyouhang/Led3D)
- [InsightFace](https://github.com/deepinsight/insightface)

Note that we re-implement the data preprocessing pipeline of Led3D (originally written in Matlab) in python.

Our IResNet 3D FR is based on ArcFace in [InsightFace](https://github.com/deepinsight/insightface) and fine-tuned with FaceScape dataset.

### 2D Face Generation
- [StyleGAN2](https://github.com/NVlabs/stylegan2)

### 3D Face Generation
- [FLAME](https://github.com/HavenFeng/photometric_optimization)
- [DECA](https://github.com/yfeng95/DECA/blob/master/fetch_data.sh)

The texture space and vertex mask can be downloaded at https://flame.is.tue.mpg.de/

## Code sample

We here put the code sample for LVE algorithm and CMA-ES ask-tell interface.

```python
import cma
import numpy as np
# initialize CMA-ES solver with random vector
if not args.mm3d:
    rand = np.random.randn(cfg.styleGAN2.latent)  # 512d
else:
    rand = np.zeros(cfg.shape_params + cfg.tex_params)

cmaes = cma.CMAEvolutionStrategy(rand, args.sigma, {'popsize': args.population_size})
while (count < args.iters):
    cma_candidates = cmaes.ask()
    candidates = np.asarray(cma_candidates)

    latents = candidates.copy()
    faces2d, faces3d = generate_master_faces(latents=latents, run=run, count=count)

    scores, match = calculate_scores(run=run, count=count, faces2d=faces2d, faces3d=faces3d, candidates=latents,
                                     logger=logger)

    assert len(scores) == len(cma_candidates)
    if args.mm3d:
        scores, mean_reg = regularize_shape_vector(scores, latents)
        logger.info(f'Iter: {count}: regularization term mean: {mean_reg}')

    cmaes.tell(cma_candidates, np.array(scores, dtype=float))
    
    # save cma-es sovler status for resume purpose
    with open(f'{os.path.join(log_dir, str(run), "cma")}/cma_{count:04d}.pkl', 'wb') as file:
        pickle.dump(cmaes, file)
    
    # optional
    clean_intermediates(run)
    count = count + 1
```

## Result
We attached a master face that we generated in the supplementary materials too.