#!/bin/bash

# 可配置参数
export CUDA_VISIBLE_DEVICES=0
model_name=LightTS
root_path=./dataset/traffic/
data_path=traffic.csv
features=M
e_layers=2
d_layers=1
factor=3
enc_in=862
dec_in=862
c_out=862
des='Exp'
itr=1

# 循环参数
pred_lengths=(720)
seq_lengths=(96 336 720)

for seq_len in "${seq_lengths[@]}"; do
  for pred_len in "${pred_lengths[@]}"; do
    model_id="ECL_${seq_len}_${pred_len}"
    python -u run.py \
      --task_name long_term_forecast \
      --is_training 1 \
      --root_path $root_path \
      --data_path $data_path \
      --model_id $model_id \
      --model $model_name \
      --data custom \
      --features $features \
      --seq_len $seq_len \
      --pred_len $pred_len \
      --e_layers $e_layers \
      --d_layers $d_layers \
      --factor $factor \
      --enc_in $enc_in \
      --dec_in $dec_in \
      --c_out $c_out \
      --des $des \
      --itr $itr
  done
done
