#!/bin/bash

export CUDA_VISIBLE_DEVICES=0

model_name=VIPER

declare -a pred_lens=(96 192 336 720)
declare -a seq_lens=( 720)

for pred_len in "${pred_lens[@]}"; do
  for seq_len in "${seq_lens[@]}"; do
    cmd="python -u run.py \
      --task_name long_term_forecast \
      --is_training 1 \
      --root_path ./dataset/ETT-small/ \
      --data_path ETTm1.csv \
      --model_id "ETTm1_${seq_len}_${pred_len}" \
      --model "$model_name" \
      --data ETTm1 \
      --features M \
      --seq_len "$seq_len" \
      --pred_len "$pred_len" \
      --enc_in 7 \
      --dec_in 7 \
      --c_out 7 \
      --des 'Exp' \
      --itr 1 \
      --train_epochs 24 \
      "

    if [ "$seq_len" -eq 720 ] && [ "$pred_len" -eq 96 ]; then
      cmd="$cmd --learning_rate 1e-5  --batch_size 8"
    fi
    if [ "$seq_len" -eq 720 ] && [ "$pred_len" -eq 192 ]; then
      cmd="$cmd --learning_rate 1e-5  --batch_size 8"
    fi

    eval $cmd
  done
done

