#!/bin/bash

export CUDA_VISIBLE_DEVICES=0

model_name=VIPER

declare -a pred_lens=(96 192 336 720)
declare -a seq_lens=(96)

for pred_len in "${pred_lens[@]}"; do
  for seq_len in "${seq_lens[@]}"; do
    cmd="python -u run.py \
      --task_name long_term_forecast \
      --is_training 1 \
      --root_path ./dataset/exchange_rate/ \
      --data_path exchange_rate.csv \
      --model_id "exchange_rate_${seq_len}_${pred_len}" \
      --model "$model_name" \
      --data custom \
      --features M \
      --seq_len "$seq_len" \
      --pred_len "$pred_len" \
      --enc_in 8 \
      --dec_in 8 \
      --c_out 8 \
      --des 'Exp' \
      --itr 1 \
      "

    eval $cmd
  done
done
