#!/bin/bash

export CUDA_VISIBLE_DEVICES=0

model_name=VIPER

declare -a pred_lens=(96 192 336 720)
declare -a seq_lens=( 720)
declare -a seq_lens_custom=( 720 )  

for pred_len in "${pred_lens[@]}"; do
  if [ "$pred_len" -eq 720 ]; then
    seq_lens_to_use=("${seq_lens_custom[@]}")  
  else
    seq_lens_to_use=("${seq_lens[@]}")  
  fi

  for seq_len in "${seq_lens_to_use[@]}"; do
    cmd="python -u run.py \
      --task_name long_term_forecast \
      --is_training 1 \
      --root_path ./dataset/weather/ \
      --data_path weather.csv \
      --model_id "weather_${seq_len}_${pred_len}" \
      --model "$model_name" \
      --data custom \
      --features M \
      --seq_len "$seq_len" \
      --pred_len "$pred_len" \
      --enc_in 21 \
      --dec_in 21 \
      --c_out 21 \
      --des 'Exp' \
      --itr 1 \
      --batch_size 32 \
      --learning_rate 2.5e-5"

    eval $cmd
  done
done
