from .batch_to import batch_to
def forward_iter(model, batch, device='cpu', optimizer=None):
    if model.training and optimizer:
        optimizer.zero_grad()
    batch = batch_to(batch, device=device)
    outputs = model(**batch)
    if model.training and optimizer:
        optimizer.step()
    if model.training:
        loss = model.loss.item()
    else:
        loss = None
    labels = batch['labels']
    _batch_size = labels.size(0)
    return outputs, labels, loss, _batch_size