from rich.console import Console
console = Console()
from rich.progress import (
    BarColumn,
    Progress,
    SpinnerColumn,
    TextColumn,
    TimeElapsedColumn,
)

timer = Progress(
        TimeElapsedColumn(),
        TextColumn("{task.description}"),
        SpinnerColumn("aesthetic"),
        console=console
    )

#use this function to create a python rich timer bar in other parts of the code:
def timer_bar(description):
    with timer:
        task = timer.add_task(description, start=False)
        timer.start_task(task)
        return task #return the task so that it can be used to stop the timer

#use this function to stop the timer bar:
def stop_timer_bar(task):    
    timer.stop_task(task)
    timer.remove_task(task) #remove the task from the timer bar
