import torch
from clip import clip


def load_clip_to_cpu(backbone_name):
    # backbone_name: "RN50" / "RN101" / "ViT-B/32" / "ViT-B/16" / "ViT-L/14"
    url = clip._MODELS[backbone_name]
    model_path = clip._download(url)

    try:
        # loading JIT archive
        model = torch.jit.load(model_path, map_location="cpu").eval()
        state_dict = None

    except RuntimeError:
        state_dict = torch.load(model_path, map_location="cpu")

    model = clip.build_model(state_dict or model.state_dict())

    return model