import os

class PromptTemplate:
    """A prompt template."""
    def __init__(self, template_name: str):
        template_path = os.path.join(os.path.dirname(__file__), f"{template_name}.txt")
        self.template: str = open(template_path).read()

    def __call__(self, **kwargs) -> str:
        return self.template.format(**kwargs)