#include <cmath>
#include <algorithm>
#include <chrono>
#include "IBOSS_algorithm.h"

#include "floyd_rivest_select.h"
using namespace std;

// constructor
IBOSS_algorithm::IBOSS_algorithm(the_Data *input_data, int n){
    this -> data = input_data;

    this -> N  = input_data -> N;
    this -> p  = input_data -> p;
    this -> n  = n;
    this -> r = n / 2 / this -> p;

    thresholds_upper.resize(this -> p);
    thresholds_lower.resize(this -> p);
    if_selected.resize(this -> N);
}

IBOSS_algorithm::~IBOSS_algorithm(){
}

vector<T> IBOSS_algorithm::Execute(){
    vector<T> estimated_beta;
    select();
    compute();
    estimated_beta = solve();
    return estimated_beta;
}

vector<T> IBOSS_algorithm::Execute_adjust(){
    vector<T> estimated_beta;
    select();
    compute();
    estimated_beta = solve();
    adjust_beta_0(estimated_beta);
    return estimated_beta;
}

void IBOSS_algorithm::select(){
    for(int i =0; i < N; ++i){
        if_selected[i] = false;
    }
    vector<T> tmp_block_vector(N);
    for (int j = 0; j < p; ++j ){
        int the_size = 0;
        for (int i=0; i < N; ++i){
            if(if_selected[i]){
                continue;
            }
            tmp_block_vector[the_size] = data -> Z(i, j);
            ++the_size;
        }
        miniselect::floyd_rivest_select(tmp_block_vector.begin(), tmp_block_vector.begin() + the_size - r, tmp_block_vector.begin() + the_size);
        thresholds_upper[j] = *(tmp_block_vector.begin() + the_size - r);
        miniselect::floyd_rivest_select(tmp_block_vector.begin(), tmp_block_vector.begin() + r - 1, tmp_block_vector.begin() + the_size - r );
        thresholds_lower[j] = *(tmp_block_vector.begin() + r - 1);

        for (int i=0; i < N; ++i){
            if(if_selected[i]){
                continue;
            }
            if((data -> Z(i, j) >= thresholds_upper[j])
                    ||
                    (data -> Z(i, j) <= thresholds_lower[j])){
                if_selected[i] = true;
            }
        }
    }
}

void IBOSS_algorithm::compute(){
    XXT.init(p+1, p+1);

    XY.resize(p+1);
    for(int j=0; j < p+1; ++j){
            XY[j] = 0;
    }

    for(int counter =0; counter < N; ++ counter){

        if(!if_selected[counter]){
            continue;
        }
        if_selected[counter] = true;
        XXT(0, 0) += 1;
        for( int i = 1; i< p+1; ++i ){
            XXT(i, 0) += data->Z(counter, i-1);
        }
        for( int i = 1; i< p+1; ++i ) {
            for(int j = 1; j<= i; ++j){
                XXT(i,j) += data->Z(counter, i-1) * data->Z(counter, j-1);
            }
            XY[i] += data->Z(counter, i-1) * (data->y[counter]);
        }
        XY[0] += (data->y[counter]);
    }
}

// Gaussian elimination
vector<T> IBOSS_algorithm::solve(){
    vector<T> estimated_beta(p+1);
    for(int i = 0; i< p+1; ++i){
        for(int j =i; j< p+1; ++j){
            XXT(i, j) = XXT(j, i);
        }
    }

    for(int counter = 0; counter < p; ++counter){
        for(int i = counter + 1; i < p+1; ++i){
            T the_ratio = XXT(counter, i) / XXT(counter, counter);
            for(int j = counter; j < p+1; ++j){
                XXT(j, i) -= the_ratio * XXT(j, counter);
            }
            XY[i] -= the_ratio * XY[counter];
        }
    }

    for(int i = p; i>=0; --i){
        estimated_beta[i] =  XY[i];
        for(int j = i+1; j<=p; ++j){
            estimated_beta[i] -= XXT(j, i) * estimated_beta[j];
        }
        estimated_beta[i] /= XXT(i, i);
    }
    return estimated_beta;
}


void IBOSS_algorithm::adjust_beta_0(vector<T> &estimated_beta){
    T y_mean = 0;
    vector<T> z_mean(p);
    for(int j = 0; j< p; ++j){
        z_mean[j] = 0;
    }
    for(int i = 0; i < N; ++i){
        y_mean += data -> y[i];
    }
    y_mean /= N;
    for(int i = 0; i < N; ++i){
        for(int j = 0; j <p; ++j){
            z_mean[j] += data -> Z(i, j);
        }
    }
    for(int j = 0; j <p; ++j){
        z_mean[j] /= N;
    }
    estimated_beta[0] = y_mean;
    for(int j = 0; j < p; ++j){
        estimated_beta[0] -= z_mean[j] * estimated_beta[j+1];
    }
}
