#ifndef IBOSS_ALGORITHM_H_
#define IBOSS_ALGORITHM_H_

#include<iostream>
#include<vector>
#include<cmath>

#include "def_the_type.h"
#include "data.h"
using namespace std;
class IBOSS_algorithm {
    private:


        // length N, flag, indicate if an observation is selected
        vector<bool> if_selected;
        // length p, thresholds
        // the (N - |I| - r + 1)th
        vector<T> thresholds_upper;
        // the (r)th
        vector<T> thresholds_lower;

        //vector<vector<T>> XXT;
        the_Matrix XXT;
        vector<T> XY;

        // select thresholds
        void select();
        // compute the matrices need for LSE
        void compute();
        // solve the LSE
        vector<T> solve();

        // adjust beta_0
        void adjust_beta_0(vector<T> &estimated_beta);


    public:
        the_Data *data;
        IBOSS_algorithm(the_Data *input_data, int n);
        ~IBOSS_algorithm();
        int N, p, n, r;
        // original IBOSS
        vector<T> Execute();
        // original IBOSS with adjusted beta_0
        vector<T> Execute_adjust();
};

#endif
