#ifndef NEW_ALGORITHM_H_
#define NEW_ALGORITHM_H_

#include<iostream>
#include<vector>
#include<cmath>

#include "def_the_type.h"
#include "data.h"
using namespace std;
class NEW_algorithm {
    private:

        vector<bool> if_selected;

        // length p, thresholds
        // the rth largest
        vector<T> thresholds_upper;
        // the rth smallest
        vector<T> thresholds_lower;

        the_Matrix XXT;
        vector<T> XY;

        // averaging data
        the_Matrix lower_averaging_Z;
        vector<T> lower_averaging_y;
        // count the observations within each group
        vector<int> lower_averaging_counter;

        the_Matrix upper_averaging_Z;
        vector<T> upper_averaging_y;
        vector<int> upper_averaging_counter;

        // select thresholds
        void select_and_average();
        // compute the matrices need for LSE
        void compute();
        // solve the LSE
        vector<T> solve();


    public:
        the_Data *data;
        NEW_algorithm(the_Data *input_data);
        ~NEW_algorithm();
        int N, n, p, r;
        vector<T> Execute();
};

#endif
