#include <algorithm>
#include <chrono>
#include <random>
#include <functional>
#include "SLEV_algorithm.h"
using namespace std;

SLEV_algorithm::SLEV_algorithm(the_Data *input_data, int n){
    this -> alpha = 1.0;
    this -> data = input_data;
    this -> N = input_data -> N;
    this -> p = input_data -> p;
    this -> n = n;
    H.resize(N);
    H_sum.resize(N);
    if_selected.resize(this -> N);
    for(int i = 0; i < N; ++i)
        if_selected[i] = false;
}
SLEV_algorithm::~SLEV_algorithm(){
}
vector<T> SLEV_algorithm::Execute(){
    compute();
    select();
    vector<T> estimate_beta;
    estimate_beta = solve();
    return estimate_beta;
}

void SLEV_algorithm::compute(){
    XXT.init(p + 1, p + 1);
    XXT_inv.init(p + 1, p + 1);

    for(int counter = 0; counter < N; ++counter){
        XXT(0, 0) += 1;
        for(int i = 1; i < p + 1; ++i){
            XXT(i, 0) += data->Z(counter, i - 1);
        }
        for(int i = 0; i < p + 1; ++i)
            for(int j = 1; j <= i; ++j)
                XXT(i, j) += (data->Z(counter, i-1)) * (data->Z(counter, j - 1));
    }
    for(int i = 0; i < p+1; ++i)
        for(int j = i + 1; j < p+1; ++j)
            XXT(i, j) = XXT(j , i);


    Matrix_inverse(XXT, XXT_inv);
    
    T h_sum = 0;
    for(int i = 0; i < N; ++i){
        H[i] = XXT_inv(0, 0);
        for(int k = 1; k < p + 1; ++k)
            H[i] += 2 * data -> Z(i, k - 1) * XXT_inv(0, k);
        for(int k = 1; k < p + 1; ++k){
            H[i] += data -> Z(i, k - 1) * data -> Z(i, k - 1) * XXT_inv(k, k);
            for(int l = k+1; l < p + 1; ++l)
                H[i] += 2 * data -> Z(i, k - 1) * data -> Z(i, l - 1) * XXT_inv(k, l);
        }
        h_sum = h_sum + H[i];
    }

    for(int i = 0; i < N; ++i){
        H[i] = alpha * H[i] / h_sum + (1 - alpha) / N;
    }
    H_sum[0] = H[0];
    for(int i = 1; i < N; ++i)
        H_sum[i] = H_sum[i-1] + H[i];
    return;
}

int SLEV_algorithm::find_index(T t){
    int left = 0;
    int right = N - 1;
    int middle;
    while(true){
        middle = (left + right) / 2;
        if(t < H_sum[middle]){
            right = middle;
        }else{
            left = middle;
        }
        if(left == right){
            return right;
        }
        if(right == left + 1){
            if(t < H_sum[left]){
                return left;
            }else{
                return right;
            }
        }
    }
    return 0;
}

void SLEV_algorithm::select(){
    unsigned seed = chrono::system_clock::now().time_since_epoch().count();
    default_random_engine generator(seed);
    uniform_real_distribution<T> the_uniform(0., 1.);
    auto the_generator = bind(the_uniform, generator);
    int count = 0;
    while(count < n){
        int index = find_index(the_generator());
        if(if_selected[index])
            continue;
        if_selected[index] = true;
        ++count;
    }
    return;
}

vector<T> SLEV_algorithm::solve(){
    XXT.init(p + 1, p + 1);
    XY.resize(p + 1);
    for(int i = 0; i < p + 1; ++i){
        XY[i] = 0;
    }
    for(int counter = 0; counter < N; ++counter){
        if(!if_selected[counter])
            continue;
        XXT(0, 0) += 1. / H[counter];
        for(int i = 1; i < p + 1; ++i)
            XXT(i, 0) += data->Z(counter, i - 1) / H[counter];
        for(int i = 1; i < p + 1; ++i){
            for(int j = 1; j <= i; ++j)
                XXT(i, j) += (data->Z(counter, i - 1)) * (data->Z(counter, j - 1)) / H[counter];
            XY[i] += data->Z(counter, i - 1) * (data->y[counter]) / H[counter];
        }
        XY[0] += data->y[counter] / H[counter];
    }
    for(int i = 0; i < p + 1; ++i)
        for(int j = i + 1; j < p + 1; ++j)
            XXT(i, j) = XXT(j, i);
    vector<T> estimated_beta(p + 1);
    for(int counter = 0; counter < p; ++counter){
        for(int i = counter + 1; i < p+1; ++i){
            T the_ratio = XXT(counter, i) / XXT(counter, counter);
            for(int j = counter; j < p + 1; ++j)
                XXT(j, i) -= the_ratio * XXT(j, counter);
            XY[i] -= the_ratio * XY[counter];
        }
    }
    for(int i = p; i >=0; --i){
        estimated_beta[i] = XY[i];
        for(int j = i+1; j <= p; ++j)
            estimated_beta[i] -= XXT(j, i) * estimated_beta[j];
        estimated_beta[i] /= XXT(i, i);
    }
    return estimated_beta;
}
