#ifndef EXPERIMENTS_H_
#define EXPERIMENTS_H_

// possible distributions of Z
// 0: uniform | 1: normal | 2: lognormal | 3: student t | 4: normal with equal correlation | 5: normal mixture
#define _Z_UNIFORM_DISTRIBUTION_CODE 0
#define _Z_NORMAL_DISTRIBUTION_CODE 1
#define _Z_LOGNORMAL_DISTRIBUTION_CODE 2
#define _Z_T_DISTRIBUTION_CODE 3
#define _Z_NORMAL_CORRELATION_DISTRIBUTION_CODE 4
#define _Z_NORMAL_MIXTURE_DISTRIBUTION_CODE 5

// possible distributions of y
// 1: normal | 5: centered chi-squared
#define _y_NORMAL_DISTRIBUTION_CODE 1
#define _y_CHI_SQUARED_DISTRIBUTION_CODE 5

// results are obtained from 100 replications
#define _REPEAT_TIME_CONFIG 100

///////////////////////////////// experiment settings //////////////////////////////////////

// if run the algorithm or not
#define _RUN_NEW_CONFIG true
#define _RUN_VDA_CONFIG true
#define _RUN_IBOSS_CONFIG true
#define _RUN_IBOSS_ADJUST_CONFIG false
#define _RUN_UNIFORM_CONFIG true
#define _RUN_SRHT_CONFIG true
#define _RUN_SLEV_CONFIG true
#define _RUN_FULL_CONFIG true

// N: total sample size. p: dimension of Z
#define _N_CONFIG 80000
#define _p_CONFIG 50

// the distribution of Z
#define _Z_DIS_CONFIG _Z_NORMAL_MIXTURE_DISTRIBUTION_CODE
// the distribution of y
#define _y_DIS_CONFIG _y_CHI_SQUARED_DISTRIBUTION_CODE

#endif
