#include <algorithm>
#include <chrono>
#include "UNIFORM_algorithm.h"
using namespace std;

// constructor
UNIFORM_algorithm::UNIFORM_algorithm(the_Data *input_data, int n){
    this -> data = input_data;

    this -> N  = input_data -> N;
    this -> p  = input_data -> p;
    this -> n  = n;

    if_selected.resize(this -> N);
}

UNIFORM_algorithm::~UNIFORM_algorithm(){
}

vector<T> UNIFORM_algorithm::Execute(){
    select();
    compute();
    vector<T> estimated_beta;
    estimated_beta = solve();
    return estimated_beta;
}
vector<T> UNIFORM_algorithm::Execute_full(){
    for(int i = 0; i< n; ++i ){
        if_selected[i] = true;
    }
    compute();
    vector<T> estimated_beta;
    estimated_beta = solve();
    return estimated_beta;
}

void UNIFORM_algorithm::select(){
    permute_indices.resize(N);
    for(int i = 0; i< N; ++i ){
        permute_indices[i] = i;
    }
    random_shuffle(permute_indices.begin(), permute_indices.end());
    for(int i = 0; i< n; ++i ){
        if_selected[permute_indices[i]] = true;
    }
}

void UNIFORM_algorithm::compute(){
    XXT.init(p+1, p+1);

    XY.resize(p+1);
    for(int i=0; i < p+1; ++i){
            XY[i] = 0;
    }

    for(int counter =0; counter < N; ++ counter){
        if(!if_selected[counter]){
            continue;
        }
        if_selected[counter] = true;
        XXT(0,0) += 1;
        for( int i = 1; i< p+1; ++i ){
            XXT(i,0) += data->Z(counter, i-1);
        }
        for( int i = 1; i< p+1; ++i ) {
            for(int j = 1; j<= i; ++j){
                XXT(i, j) += (data->Z(counter, i-1)) * (data->Z(counter, j-1));
            }
            XY[i] += data->Z(counter, i-1) * (data->y[counter]);
        }
        XY[0] += (data->y[counter]);
    }
}

// Gaussian elimination
vector<T> UNIFORM_algorithm::solve(){

    vector<T> estimated_beta(p+1);

    for(int i = 0; i< p+1; ++i){
        for(int j =i; j< p+1; ++j){
            XXT(i, j) = XXT(j, i);
        }
    }

    for(int counter = 0; counter < p; ++counter){
        for(int i = counter + 1; i < p+1; ++i){
            T the_ratio = XXT(counter, i) / XXT(counter, counter);
            for(int j = counter; j < p+1; ++j){
                XXT(j, i) -= the_ratio * XXT(j, counter);
                        
            }
            XY[i] -= the_ratio * XY[counter];
        }
    }


    for(int i = p; i>=0; --i){
        estimated_beta[i] =  XY[i];
        for(int j = i+1; j<=p; ++j){
            estimated_beta[i] -= XXT(j, i) * estimated_beta[j];
        }
        estimated_beta[i] /= XXT(i, i);
    }
    return estimated_beta;

}
