#include <random>
#include <chrono>
#include <functional>
#include <cmath>
#include <iostream>
#include <fstream>
#include "data.h"

void the_Matrix::init(int nrow, int ncol){
    this -> nrow = nrow;
    this -> ncol = ncol;
    matrix.resize( nrow * ncol );
    for(int i=0; i < nrow * ncol; ++i){
        matrix[ i ] = 0;
    }
}

the_Data::the_Data(int N, int p){
    this -> N  = N;
    this -> p  = p;
    y.resize(N);
    Z.init(N, p);
    
}
the_Data::~the_Data(){
}

void the_Data::uniform_generate(){
    unsigned seed = chrono::system_clock::now().time_since_epoch().count();
    default_random_engine generator(seed);
    uniform_real_distribution<T> the_uniform(0., 1.);
    auto the_generator = bind(the_uniform, generator);

    for(int i=0; i < N; ++i){
        for(int j=0; j < p; ++j) {
            Z(i,j) = the_generator();
        }
    }
}

void the_Data::normal_generate(){
    unsigned seed = chrono::system_clock::now().time_since_epoch().count();
    default_random_engine generator(seed);
    normal_distribution<T> the_normal(0., 1.);
    auto the_generator = bind(the_normal, generator);

    for(int i=0; i < N; ++i){
        for(int j=0; j < p; ++j) {
            Z(i,j) = the_generator();
        }
    }
}

void the_Data::t_generate(){
    unsigned seed = chrono::system_clock::now().time_since_epoch().count();
    default_random_engine generator(seed);
    student_t_distribution<T> the_t(3.);
    auto the_generator = bind(the_t, generator);

    for(int i=0; i < N; ++i){
        for(int j=0; j < p; ++j) {
            Z(i,j) = the_generator();
        }
    }
}

void the_Data::lognormal_generate(){
    unsigned seed = chrono::system_clock::now().time_since_epoch().count();
    default_random_engine generator(seed);
    lognormal_distribution<T> the_lognormal(0., 1.);
    auto the_generator = bind(the_lognormal, generator);

    for(int i=0; i < N; ++i){
        for(int j=0; j < p; ++j) {
            Z(i,j) = the_generator();
        }
    }
}

void the_Data::normal_equal_correlation_generate(){
    unsigned seed = chrono::system_clock::now().time_since_epoch().count();
    default_random_engine generator(seed);
    normal_distribution<T> the_normal(0., 1.);
    auto the_generator = bind(the_normal, generator);
    T tmp = sqrt(2.);
    T tmp_random;
    for(int i=0; i < N; ++i){
        tmp_random = the_generator() / tmp;
        for(int j=0; j < p; ++j) {
            Z(i,j) = the_generator() / tmp + tmp_random;
        }
    }
}

void the_Data::normal_mixture_generate(){
    unsigned seed = chrono::system_clock::now().time_since_epoch().count();
    default_random_engine generator(seed);
    normal_distribution<T> the_normal(0., 1.);
    auto the_generator = bind(the_normal, generator);
    T tmp = sqrt(2.);
    T tmp_random;

    vector<bool> the_flag(N);
    for(int i=0; i < N; ++i){
        the_flag[i] = rand() % 2;
    }
    for(int i=0; i < N; ++i){
        tmp_random = the_generator() / tmp;
        for(int j=0; j < p; ++j) {
            Z(i,j) = the_generator() / tmp + tmp_random;
            if(the_flag[i]){
                Z(i,j) += 1;
            }else{
                Z(i,j) += -1;
            }
        }
    }
}


void the_Data::normal_generate_y(vector<T> &true_beta){
    unsigned seed = chrono::system_clock::now().time_since_epoch().count();
    default_random_engine generator(seed);
    normal_distribution<T> the_normal(0., 1.);
    auto the_generator = bind(the_normal, generator);
    for(int i=0; i < N; ++i){
        y[i] = the_generator() + true_beta[0];
        for(int j = 1; j < p+1; ++j){
            y[i] += true_beta[j] * Z(i,j-1);
        }
    }
}

void the_Data::chi_squared_generate_y(vector<T> &true_beta){
    unsigned seed = chrono::system_clock::now().time_since_epoch().count();
    default_random_engine generator(seed);
    normal_distribution<T> the_normal(0., 1.);
    auto the_generator = bind(the_normal, generator);
    T tmp;
    T my_sqrt2 = sqrt(2.);
    for(int i=0; i < N; ++i){
        tmp = the_generator();
        y[i] = (tmp * tmp - 1.) / my_sqrt2 + true_beta[0];
        for(int j = 1; j < p+1; ++j){
            y[i] += true_beta[j] * Z(i,j-1);
        }
    }
}



void the_Data::readFile(const char *fileName) {
    ifstream the_file;
    int count = 0;
    the_file.open(fileName, ios::in);
    for (int i = 0; i < N; ++i){
        the_file >> y[i];
        for (int j = 0; j < p; ++j){
            the_file >> Z(i,j);
        }
    }
    the_file.close();

}
