#ifndef DATA_H_
#define DATA_H_

#include<iostream>
#include<vector>
#include<assert.h>

#include "def_the_type.h"
using namespace std;

class the_Matrix{
    public:
        void init(int nrow, int ncol);
        //~the_Matrix();
        inline T& operator()(int i, int j);
        int nrow, ncol;
        vector<T> matrix;
};

inline T& the_Matrix::operator()(int i, int j){
    return matrix[i * ncol + j];
}

// Inputs: A and B; Output: C = A^{-1} B                                                                                                                                                                                                      
inline void Matrix_solve(the_Matrix& A, the_Matrix& B, the_Matrix& C){                                                                                                                                                                        
    assert(                                                                                                                                                                                                                                   
            (A.nrow == A.ncol) && (A.nrow == C.nrow) && (A.ncol == B.nrow) && (B.ncol == C.ncol)                                                                                                                                              
          );                                                                                                                                                                                                                                
    the_Matrix A_copy = A, B_copy = B;                                                                                                                                                                                                        
    for(size_t counter = 0; counter < A_copy.nrow; ++counter){                                                                                                                                                                                
        for(size_t i = counter + 1; i < A_copy.nrow; ++i){                                                                                                                                                                                    
            T the_ratio = A_copy(i, counter) / A_copy(counter, counter);                                                                                                                                                                      
            for(size_t j = counter; j < A_copy.ncol; ++j){                                                                                                                                                                                    
                A_copy(i, j) -= the_ratio * A_copy(counter, j);                                                                                                                                                                               
            }                                                                                                                                                                                                                                 
            for(size_t j = 0; j < B_copy.ncol; ++j){                                                                                                                                                                                          
                B_copy(i, j) -= the_ratio * B_copy(counter, j);                                                                                                                                                                               
            }                                                                                                                                                                                                                                 
        }                                                                                                                                                                                                                                     
    }                                                                                                                                                                                                                                         
    for(size_t j = 0; j < C.ncol; ++j){                                                                                                                                                                                                       
        size_t i = A_copy.ncol -1;                                                                                                                                                                                                            
        while(true){                                                                                                                                                                                                                          
            C(i, j) = B_copy(i, j);                                                                                                                                                                                                           
            for(size_t counter = i+1; counter < A_copy.ncol; ++counter){                                                                                                                                                                      
                C(i, j) -= A_copy(i, counter) * C(counter, j);                                                                                                                                                                                
            }                                                                                                                                                                                                                                 
            C(i, j) /= A_copy(i, i);                                                                                                                                                                                                          

            if(i == 0) break;                                                                                                                                                                                                                 
            --i;                                                                                                                                                                                                                              
        }                                                                                                                                                                                                                                     
    }                                                                                                                                                                                                                                         
    return ;                                                                                                                                                                                                                                  
}                                                                                                                                                                                                                                             

// Compute the inverse of A and assign the result to B = A^{-1}                                                                                                                                                                               
inline void Matrix_inverse(the_Matrix& A, the_Matrix& B){                                                                                                                                                                                     
    assert(                                                                                                                                                                                                                                   
            (A.nrow == A.ncol) && (A.nrow == B.nrow) && (B.nrow == B.ncol)                                                                                                                                                                    
          );                                                                                                                                                                                                                                
    the_Matrix I;                                                                                                                                                                                                                             
    I.init(A.nrow, A.ncol);                                                                                                                                                                                                                   
    for(size_t i = 0; i < I.nrow; ++i ){                                                                                                                                                                                                      
        I(i,i) = 1;                                                                                                                                                                                                                           
    }                                                                                                                                                                                                                                         
    Matrix_solve(A, I, B);                                                                                                                                                                                                                    
    return ;                                                                                                                                                                                                                                  
}                   

class the_Data {
    public:
        the_Data(int N, int p);
        ~the_Data();
        the_Matrix Z;
        vector<T> y;
        int N, p;

        // various data generation methods
        void uniform_generate();
        void normal_generate();
        void lognormal_generate();
        void t_generate();
        void normal_equal_correlation_generate();
        void normal_mixture_generate();

        // methods for generating y
        void normal_generate_y(vector<T> &true_beta);
        void chi_squared_generate_y(vector<T> &true_beta);

        // read real data
        void readFile(const char *);
};

#endif
