lagging=$1
future_num=$2
future_mode=$3
lang=de
MUSTC_ROOT=/path/to/datasets/MuST-C/fine/en-${lang}
SRC_LIST_OF_AUDIO=${MUSTC_ROOT}/data/tst-COMMON/test_data/tst-COMMON.wav_list
TGT_FILE=${MUSTC_ROOT}/data/tst-COMMON/test_data/tst-COMMON.${lang}
ST_SAVE_DIR=/path/to/fine/save_models/${lang}/finetune
CHECKPOINT_FILENAME=en-${lang}_refine_online.pt
WAV2VEC_DIR=/path/to/fine/pretrain_models/wav2vec_small.pt
OUTPUT=${ST_SAVE_DIR}/results/wait${lagging}len${future_num}${future_mode}/
fpdr=1
port=$((${lagging}*3+${future_num}*2+42845))
echo ${port}

CUDA_VISIBLE_DEVICES=0 simuleval \
    --agent ./examples/speech_to_text/simultaneous_translation/agents/fine_agent_wav2vec_cif.py \
    --source ${SRC_LIST_OF_AUDIO} \
    --target ${TGT_FILE} \
    --data-bin ${MUSTC_ROOT} \
    --config config_wave.yaml \
    --w2v2-model-path  ${WAV2VEC_DIR}\
    --model-path ${ST_SAVE_DIR}/${CHECKPOINT_FILENAME} \
    --output ${OUTPUT} \
    --waitk-lagging ${lagging} \
    --fixed-pre-decision-ratio ${fpdr} \
    --prefix-size 1 \
    --future-num ${future_num} \
    --future-mode ${future_mode} \
    --max-source-positions 3200000 \
    --scores \
    --port ${port} \
    --gpu \
    --lang ${lang}