#!/bin/bash

# Lines that begin with #SBATCH specify commands to be used by SLURM for scheduling
#SBATCH --job-name=gerrymandering                            # sets the job name if not set from environment
#SBATCH --array=0-20                                  # Submit 8 array jobs, throttling to 4 at a time
#SBATCH --output logs/%x_%A_%a.log                   # redirect STDOUT to; %j is the jobid, _%A_%a is array task id
#SBATCH --error logs/%x_%A_%a.log                    # redirect STDERR to; %j is the jobid,_%A_%a is array task id
#SBATCH --account=scavenger                           # set QOS, this will determine what resources can be requested
#SBATCH --qos=scavenger                                 # set QOS, this will determine what resources can be requested
#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task=4
#SBATCH --partition=scavenger
#SBATCH --mem 16gb                                      # memory required by job; MB will be assumed
#SBATCH --mail-user <email_id>
#SBATCH --mail-type=END,TIME_LIMIT,FAIL,ARRAY_TASKS
#SBATCH --time=1:00:00                                 # how long will the job will take to complete; format=hh:mm:ss

# python poison_crafting/craft_poisons_fc.py --model alexnet --pretrain_dataset CIFAR10 --l2 --watermark_coeff 0.3 --crafting_iters 1200 --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --model_path ./CHECKPOINTS/checkpoints/my_model_chks/alexnet/alexnet_seed_1000_normalize=False_augment=False_optimizer=adam_epoch=199.t7 --step_size 0.0001 --poison_setups poison_setups/fc/num_poisons=500/setups.pickle --setup_idx $SLURM_ARRAY_TASK_ID
python poison_crafting/craft_poisons_cp.py --model resnet18 --normalize --pretrain_dataset CIFAR10 --epsilon 0.1 --crafting_iters 4000 --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --model_path ./CHECKPOINTS/checkpoints/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --poison_setups poison_setups/cp/num_poisons=100/setups.pickle --setup_idx $SLURM_ARRAY_TASK_ID