#!/bin/bash

# Lines that begin with #SBATCH specify commands to be used by SLURM for scheduling
#SBATCH --job-name=fccp                            # sets the job name if not set from environment
#SBATCH --array=0-20                                  # Submit 8 array jobs, throttling to 4 at a time
#SBATCH --output logs/%x_%A_%a.log                   # redirect STDOUT to; %j is the jobid, _%A_%a is array task id
#SBATCH --error logs/%x_%A_%a.log                    # redirect STDERR to; %j is the jobid,_%A_%a is array task id
#SBATCH --account=scavenger                           # set QOS, this will determine what resources can be requested
#SBATCH --qos=scavenger                                 # set QOS, this will determine what resources can be requested
#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task=4
#SBATCH --partition=scavenger
#SBATCH --mem 16gb                                      # memory required by job; MB will be assumed
#SBATCH --mail-user <email_id>
#SBATCH --mail-type=END,TIME_LIMIT,FAIL,ARRAY_TASKS
#SBATCH --time=24:00:00                                 # how long will the job will take to complete; format=hh:mm:ss

# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model_path ./CHECKPOINTS/checkpoints/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --lr 0.1 --optimizer adam
# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model_path ./CHECKPOINTS/checkpoints/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --lr 0.1 --optimizer adam --defense cutmix
# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model_path ./CHECKPOINTS/checkpoints/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --lr 0.1 --optimizer adam --defense mixup

# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model_path ./CHECKPOINTS/checkpoints/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --lr 0.1 --optimizer adam --e2e
# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model_path ./CHECKPOINTS/checkpoints/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --lr 0.1 --optimizer adam --e2e --defense cutmix
# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model_path ./CHECKPOINTS/checkpoints/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --lr 0.1 --optimizer adam --e2e --defense mixup

# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model resnet18 --lr 0.1 --optimizer adam --from_scratch
# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model resnet18 --lr 0.1 --optimizer adam --from_scratch --defense cutmix
# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model resnet18 --lr 0.1 --optimizer adam --from_scratch --defense mixup



# python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model_path ./CHECKPOINTS/checkpoints/my_model_chks/alexnet/alexnet_seed_1000_normalize=False_augment=False_optimizer=adam_epoch=199.t7 --model alexnet --lr 0.00015625 --optimizer adam
# python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model_path ./CHECKPOINTS/checkpoints/my_model_chks/alexnet/alexnet_seed_1000_normalize=False_augment=False_optimizer=adam_epoch=199.t7 --model alexnet --lr 0.00015625 --optimizer adam --defense cutmix
# python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model_path ./CHECKPOINTS/checkpoints/my_model_chks/alexnet/alexnet_seed_1000_normalize=False_augment=False_optimizer=adam_epoch=199.t7 --model alexnet --lr 0.00015625 --optimizer adam --defense mixup

# python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model_path ./CHECKPOINTS/checkpoints/my_model_chks/alexnet/alexnet_seed_1000_normalize=False_augment=False_optimizer=adam_epoch=199.t7 --model alexnet --lr 0.0015625 --optimizer adam --e2e
# python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model_path ./CHECKPOINTS/checkpoints/my_model_chks/alexnet/alexnet_seed_1000_normalize=False_augment=False_optimizer=adam_epoch=199.t7 --model alexnet --lr 0.0015625 --optimizer adam --e2e --defense cutmix
# python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model_path ./CHECKPOINTS/checkpoints/my_model_chks/alexnet/alexnet_seed_1000_normalize=False_augment=False_optimizer=adam_epoch=199.t7 --model alexnet --lr 0.0015625 --optimizer adam --e2e --defense mixup

# python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model alexnet --lr 0.1 --optimizer adam --from_scratch
# python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model alexnet --lr 0.1 --optimizer adam --from_scratch --defense cutmix
# python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model alexnet --lr 0.1 --optimizer adam --from_scratch --defense mixup

python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model_path ./CHECKPOINTS/checkpoints/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --lr 0.1 --optimizer adam --defense madry
python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model_path ./CHECKPOINTS/checkpoints/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --lr 0.1 --optimizer adam --defense activation_clustering

# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model_path ./CHECKPOINTS/checkpoints/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --lr 0.1 --optimizer adam --e2e --defense madry
# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model_path ./CHECKPOINTS/checkpoints/my_model_chks/resnet18_normalized/resnet18_seed_1000_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --model resnet18 --lr 0.1 --optimizer adam --e2e --defense activation_clustering

# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model resnet18 --lr 0.1 --optimizer adam --from_scratch --defense madry
# python benchmark_test.py --poisons_path baseline/cp/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 5 --trainset_size 500 --normalize --model resnet18 --lr 0.1 --optimizer adam --from_scratch --defense activation_clustering


python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model_path ./CHECKPOINTS/checkpoints/my_model_chks/alexnet/alexnet_seed_1000_normalize=False_augment=False_optimizer=adam_epoch=199.t7 --model alexnet --lr 0.00015625 --optimizer adam --defense madry
python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model_path ./CHECKPOINTS/checkpoints/my_model_chks/alexnet/alexnet_seed_1000_normalize=False_augment=False_optimizer=adam_epoch=199.t7 --model alexnet --lr 0.00015625 --optimizer adam --defense activation_clustering

# python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model_path ./CHECKPOINTS/checkpoints/my_model_chks/alexnet/alexnet_seed_1000_normalize=False_augment=False_optimizer=adam_epoch=199.t7 --model alexnet --lr 0.0015625 --optimizer adam --e2e --defense madry
# python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model_path ./CHECKPOINTS/checkpoints/my_model_chks/alexnet/alexnet_seed_1000_normalize=False_augment=False_optimizer=adam_epoch=199.t7 --model alexnet --lr 0.0015625 --optimizer adam --e2e --defense activation_clustering

python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model alexnet --lr 0.1 --optimizer adam --from_scratch --defense madry
python benchmark_test.py --poisons_path baseline/fc/$SLURM_ARRAY_TASK_ID --dataset CIFAR10 --num_poisons 500 --trainset_size 50000 --model alexnet --lr 0.1 --optimizer adam --from_scratch --defense activation_clustering