#!/bin/bash

# Lines that begin with #SBATCH specify commands to be used by SLURM for scheduling
#SBATCH --job-name=gerrymandering                            # sets the job name if not set from environment
#SBATCH --array=0-99                                  # Submit 8 array jobs, throttling to 4 at a time
#SBATCH --output logs/%x_%A_%a.log                   # redirect STDOUT to; %j is the jobid, _%A_%a is array task id
#SBATCH --error logs/%x_%A_%a.log                    # redirect STDERR to; %j is the jobid,_%A_%a is array task id
#SBATCH --account=scavenger                           # set QOS, this will determine what resources can be requested
#SBATCH --qos=scavenger                                 # set QOS, this will determine what resources can be requested
#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task=4
#SBATCH --partition=scavenger
#SBATCH --mem 16gb                                      # memory required by job; MB will be assumed
#SBATCH --mail-user <email_id>
#SBATCH --mail-type=END,TIME_LIMIT,FAIL,ARRAY_TASKS
#SBATCH --time=2:00:00                                 # how long will the job will take to complete; format=hh:mm:ss

seed=$(( $SLURM_ARRAY_TASK_ID % 10 + 1001))
# python poison_crafting/craft_poisons_htbd.py --normalize --poisons_path baseline/htbd/$SLURM_ARRAY_TASK_ID --setup_idx $SLURM_ARRAY_TASK_ID --poison_setup poison_setups/htbd/num_poisons=800/setups.pickle --model htbd_alexnet --dataset cifar10 --pretrain_dataset cifar10 --model_path ./CHECKPOINTS/my_model_chks/htbd_alexnet_normalized/htbd_alexnet_seed_${seed}_normalize=True_augment=False_optimizer=SGD_epoch=199.t7 --patch_size 8 --epsilon 0.062
python poison_crafting/craft_poisons_clbd.py --normalize --poisons_path baseline/clbd/$SLURM_ARRAY_TASK_ID --setup_idx $SLURM_ARRAY_TASK_ID --poison_setup poison_setups/htbd/num_poisons=800/setups.pickle --model resnet18 --dataset cifar10 --pretrain_dataset cifar10 --model_path pretrained_models/ResNet18_CIFAR10_adv.pth --patch_size 8