﻿using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices.WindowsRuntime;
using UnityEngine;
using UnityEngine.Tilemaps;
using UnityEngine.UI;

public class AngryStage : MonoBehaviour
{

    public GameObject character;
    public Tilemap envMap;
    public Tile tileToPlace;
    public Text taunt1;
    public int currStage;

    // Start is called before the first frame update
    void Start()
    {
        taunt1.gameObject.SetActive(false);
        currStage = 10;
    }

    private void OnCollisionEnter2D(Collision2D collision)
    {
        Debug.Log("colliding");
        if (character.transform.position.x > -6 && currStage == 10)
        {
            for (int i = -6; i < 0; i++)
            {
                envMap.SetTile(new Vector3Int(i, -4, 0), null);
            }
            //StartCoroutine(TextCoroutine(taunt1));
            currStage += 10;
        }

        //if character falls back to the ground, reset tiles
        if (character.transform.position.y < -10 && currStage > 21 && currStage < 30)
        {
            currStage = 20;
            ResetTiles();
        }

        //stage 2 first block
        if (character.transform.position.x > 2 && currStage==20)
        {
            envMap.SetTile(new Vector3Int(-1, -11, 0), tileToPlace);
            currStage += 1;
        }

        //stage 2 second block
        if (character.transform.position.x < 0 && character.transform.position.x > -1 && character.transform.position.y > -10 && currStage==21)
        {
            envMap.SetTile(new Vector3Int(-3, -10, 0), tileToPlace);
            currStage += 1;
            //Debug.Log(currStage);
        }

        //stage 2 third block
        if (character.transform.position.x < -2 && character.transform.position.x > -3 && character.transform.position.y > -9 && currStage==22)
        {
            envMap.SetTile(new Vector3Int(-1, -9, 0), tileToPlace);
            currStage += 1;
            envMap.SetTile(new Vector3Int(-1, -11, 0), null);
        }

        //stage 2 fourth block
        if (character.transform.position.y > -8 && currStage==23)
        {
            envMap.SetTile(new Vector3Int(-3, -8, 0), tileToPlace);
            currStage += 1;
            envMap.SetTile(new Vector3Int(-3, -10, 0), null);
        }

        //stage 2 fifth block
        if (character.transform.position.y > -7 && currStage==24)
        {
            envMap.SetTile(new Vector3Int(-1, -7, 0), tileToPlace);
            currStage += 1;
            envMap.SetTile(new Vector3Int(-1, -9, 0), null);
        }

        //stage 2 sixth block
        if (character.transform.position.y > -6 && currStage==25)
        {
            envMap.SetTile(new Vector3Int(-3, -6, 0), tileToPlace);
            currStage += 1;
            envMap.SetTile(new Vector3Int(-3, -8, 0), null);
        }

    }
    IEnumerator TextCoroutine(Text textToShow)
    {
        yield return new WaitForSeconds(1);
        textToShow.gameObject.SetActive(true);
    }

    private void ResetTiles()
    {
        envMap.SetTile(new Vector3Int(-1, -11, 0), null);
        envMap.SetTile(new Vector3Int(-3, -10, 0), null);
        envMap.SetTile(new Vector3Int(-1, -9, 0), null);
        envMap.SetTile(new Vector3Int(-3, -8, 0), null);
        envMap.SetTile(new Vector3Int(-1, -7, 0), null);
        envMap.SetTile(new Vector3Int(-3, -6, 0), null);
    }

}
