using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Networking;

public class DataHandler : MonoBehaviour
{
    public static string s_PlayerID, s_TotalAttempt;

    //public static string playerData = s_PlayerID + " Total Attempt: " + s_TotalAttempt;
    static string URL = "https://docs.google.com/forms/u/2/d/e/1FAIpQLSdd1FrwbQ-KK3AgP7u0oogDHLnlIRht9yGEgMRk4dqHGJc7eQ/formResponse"; // for time taken and attempts
    static string inputURL = "https://docs.google.com/forms/u/2/d/e/1FAIpQLSf5chbwbFfAye9Cd5r9wFX95x9PEuAJ9eNfpYLUV7mMK2Ryzw/formResponse"; // for keyinputs
    static string levelPosURL = "https://docs.google.com/forms/u/2/d/e/1FAIpQLSeFI9dYm0EQnByhSCIpdzpEvdJb6oMkZh-Aq6EPOdq_3KFyIw/formResponse"; // for level position

    public string TimeTaken;
    public string attempsMade;
    public string keyInputs;
    // Start is called before the first frame update
    void Start()
    {

    }

    // Update is called once per frame
    void Update()
    {

    }

    public static IEnumerator Post(string entry)
    {
        WWWForm form = new WWWForm();
        form.AddField("entry.309227414", entry);
        UnityWebRequest www = UnityWebRequest.Post(URL, form);
        yield return www.SendWebRequest();
    }

    #region input data
    /// <summary>
    /// Post time taken  and total attempts
    /// </summary>
    /// <param name="entry"></param>
    /// <returns></returns>
    public static IEnumerator PostLevelData(string timeTaken, string attempts)
    {
        WWWForm form = new WWWForm();
        form.AddField("entry.214090717", timeTaken); // time taken
        form.AddField("entry.1500211345", attempts); // attempts
        UnityWebRequest www = UnityWebRequest.Post(URL, form);
        yield return www.SendWebRequest();
    }
    /// <summary>
    /// post key inputs
    /// </summary>
    /// <param name="entry"></param>
    /// <returns></returns>
    public static IEnumerator PostInputs(string entry)
    {
        WWWForm form = new WWWForm();
        form.AddField("entry.144658420", entry);
        UnityWebRequest www = UnityWebRequest.Post(inputURL, form);
        yield return www.SendWebRequest();
    }

    /// <summary>
    /// post key inputs
    /// </summary>
    /// <param name="entry"></param>
    /// <returns></returns>
    public static IEnumerator PostLevelPos(string entry)
    {     
        WWWForm form = new WWWForm();
        form.AddField("entry.683363632", entry);
        UnityWebRequest www = UnityWebRequest.Post(levelPosURL, form);
        yield return www.SendWebRequest();
    }

    #endregion
}
