using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Tilemaps;

public class LevelLayoyutBehaviour : MonoBehaviour
{
    [HideInInspector] public int totalLength = 45;

    int currentStepLevel,lastStepHeight, concurrentspike, bernoulliParam = 0;

    [HideInInspector] public Tile noTile;
    public Tile spikeTile, landTile , endTile;

    public Tilemap envTilemap, triggerTilemap;

    public Vector3Int[] startTiles;

    string LevelLayoutPos;
    int levelNum = 0;

    // Start is called before the first frame update
    void Start()
    {
        StartingTiles();
        GenerateTile();
        EndingTiles();
    }

    // Update is called once per frame
    void Update()
    {
        if (Input.GetKeyDown(KeyCode.O))
        {
            GenerateLevel();
            PlayerController.RespawnWithNewLevel();
        }
    }
    public void GenerateLevel()
    {
        envTilemap.ClearAllTiles();
        StartingTiles();
        GenerateTile();
        EndingTiles();
    }

    void StartingTiles()
    {
        for (int a = 0; a < startTiles.Length; a++)
        {
            envTilemap.SetTile(startTiles[a], landTile);
        }
        EndlessPit();
    }

    void EndingTiles()
    {
        for (int a = -3; a <6; a++)
        {
            envTilemap.SetTile(new Vector3Int(totalLength +1, a, 0), landTile);
        }
    }

    void EndlessPit()
    {
        for(int a = -5; a <= totalLength+7; a++)
        {
            envTilemap.SetTile(new Vector3Int(a, -14, 0), spikeTile);
        }
    }
    public void GenerateTile()
    {
        //for(int i = 0; i<totalLength; i++)
        //{
        //    Vector3Int temp = new Vector3Int(i, 0, 0);
        //    envTilemap.SetTile(temp, landTile);
        //}
        int tempcounter= 0;
        LevelLayoutPos = "";
        int prevHeight = 0;
        bool tempSpike = true;
        currentStepLevel = 0;
        lastStepHeight = 0;
        bernoulliParam = Random.Range(0, 100);
        for (int i = 0; i < totalLength; i++)
        {
            int tempStepHeight = Random.Range(-2, 2);
            if(tempStepHeight - lastStepHeight > 2 )
            {
                tempStepHeight = 0; 
            }
            //int tempSpike = Random.Range(0, 2);
            int spikeRoll = Random.Range(0, 100);
            if(spikeRoll > bernoulliParam)
            {
                tempSpike = true;
                tempcounter++;
            }
            else
            {
                tempSpike = false;
            }
            currentStepLevel += tempStepHeight;
            Vector3Int temp = new Vector3Int(i, currentStepLevel, 0);
            envTilemap.SetTile(temp, landTile);
            for(int c =currentStepLevel-1; c >= -4; c--)
            {
                Vector3Int temPosFill = new Vector3Int(i, c, 0);
                envTilemap.SetTile(temPosFill, landTile);
            }
            LevelLayoutPos += "G " + temp.ToString()+"\n";
            lastStepHeight = tempStepHeight;
            currentStepLevel = 0;

            // if got spike
            if(tempSpike == true)
            {
                concurrentspike++ ;
            
                // if consecutive spikes are more than 2, just reset the counter
                if (concurrentspike >= 3)
                {
                    concurrentspike = 0;
                }
                else
                {
                    int tempFillNum = temp.y - 1;
                    Vector3Int temPosG = new Vector3Int(i, temp.y - 1, 0);
                    Vector3Int temPosS = new Vector3Int(i, temp.y, 0);
                    // set the land tile 1 tile below
                    envTilemap.SetTile(temPosG, landTile);
                    // set the spike tile on the chosen tile
                    envTilemap.SetTile(temPosS, spikeTile);
                    LevelLayoutPos += "S " + temPosS.ToString() + " G " + temPosG.ToString() + "\n";
                    for(int z = tempFillNum; z >= -4; z--)
                    {
                        Vector3Int temPosFill = new Vector3Int(i, z, 0);
                        envTilemap.SetTile(temPosFill, landTile);
                    }
            
                }
            }

            // not first element
            //if(i > 0)
            //{
            //    // current chosen is taller than previous
            //    if(tempStepHeight >= prevHeight)
            //    {
            //        // loop and add the bottom tiles for the chosen x position all the way down to the prev tile height
            //        for(int j = tempStepHeight; j > prevHeight; --j)
            //        {
            //            Vector3Int temPos = new Vector3Int(i, j, 0);
            //            envTilemap.SetTile(temPos, landTile);
            //            LevelLayoutPos += "G " + temPos.ToString() + "\n";
            //        }
            //    }
            //    // current chosen is lower than previous
            //    else
            //    {
            //        // loop and add the tiles on the previous x position all the way up to the prev tile height
            //        for (int j = tempStepHeight; j < prevHeight; ++j)
            //        {
            //            Vector3Int temPos = new Vector3Int(i-1, j, 0);
            //            envTilemap.SetTile(temPos, landTile);
            //            LevelLayoutPos +="G " + temPos.ToString() + "\n";
            //        }
            //    }
            //}

            if(i == totalLength-1)
            {
                Vector3Int temPos = new Vector3Int(i + 1, currentStepLevel, 0);
                Vector3Int temPosGoal = new Vector3Int(i + 1, currentStepLevel + 1, 0);
                envTilemap.SetTile(temPos, landTile);
                triggerTilemap.SetTile(temPosGoal, endTile);
                LevelLayoutPos += "G " + temPos.ToString() + " " + temPosGoal.ToString() + "Goal";
            }
            prevHeight = tempStepHeight;
        }
        StartCoroutine(DataHandler.PostLevelPos(levelNum + " Data set for " + DataHandler.s_PlayerID + " " + LevelLayoutPos));
        levelNum++;
    }
}
