﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.Tilemaps;
using UnityEngine.UI;

class KeyData
{
    public int times;
    public float duration;
    public float tempTime;
}

public class PlayerController : MonoBehaviour
{
    public float speed; //speed of character
    public float jumpForce; //how highhhh
    public float moveInput;

    private Rigidbody2D rb;
    private bool facingRight = true;
    private Vector2 spawnPoint; // set at construct

    private bool isGrounded;
    public Transform groundCheck;
    public float checkRadius;
    public LayerMask whatIsGround;
    private TilemapCollider2D tilemapCollider;
    public Tilemap tilemap;
    public Animator anim;

    private List<ContactPoint2D> contactPoints;
    private SpriteRenderer spriteRenderer;
    private int extraJumps;
    public int extraJumpsValue;
    public float deadFlashingTimer;

    public int attempts;
    public int attemptsLimit;
    public Text attemptTxt;

    public string levelToLoad;

    public int currLevel;
    #region
    [SerializeField] GameObject attemptLimitUI, StartTextUI;
    LevelLayoyutBehaviour LLB;
    [SerializeField] int gameLevel;
    int levelCounter = 0;
    [SerializeField] Text cue;
    #endregion

    #region input tracker
    DataHandler dH;
    int keycountA = 0;
    int keycountD = 0;
    int keycountSpace = 0;
    float keycountA_f = 0f;
    int lineCounter = 0; // counts the number of line
    int index = 0;

    #endregion
    [SerializeField] string currentLevel; // Current Level Name
    [SerializeField] int whatStage;

    Dictionary<KeyCode, KeyData> keys;

    void Start()
    {
        LLB = FindObjectOfType<LevelLayoyutBehaviour>();
        dH = FindObjectOfType<DataHandler>();
        deadFlashingTimer = 0f;
        extraJumps = extraJumpsValue;
        tilemapCollider = tilemap.GetComponent<TilemapCollider2D>();
        rb = GetComponent<Rigidbody2D>();
        spawnPoint = rb.position;
        contactPoints = new List<ContactPoint2D>();
        spriteRenderer = GetComponent<SpriteRenderer>();
        attempts = 0;
        attemptTxt.text = attempts.ToString();
        StartCoroutine(FlashStart());
        //StartCoroutine(StopMovement()); ***
        //PlayerPrefs.SetString("NextLevel", levelToLoad);

        #region key input dictionary
        keys = new Dictionary<KeyCode, KeyData>();
        // have to manually add all the keys that user needs to press
        keys.Add(KeyCode.A, new KeyData());
        keys.Add(KeyCode.D, new KeyData());
        keys.Add(KeyCode.LeftArrow, new KeyData());
        keys.Add(KeyCode.RightArrow, new KeyData());
        keys.Add(KeyCode.Space, new KeyData());
        InvokeRepeating(nameof(SendKeyInputs), 0f, 5f);
        #endregion
    }

    void FixedUpdate() //to manage physics aspects
    {
        if (deadFlashingTimer > 0f)
        {
            spriteRenderer.enabled = (Mathf.RoundToInt(deadFlashingTimer * 1000f) % 100) > 50; // blink 10 times per second
            deadFlashingTimer -= Time.deltaTime;
            if (deadFlashingTimer <= 0f)
            {
                spriteRenderer.enabled = true;
            }
        }
        isGrounded = Physics2D.OverlapCircle(groundCheck.position, checkRadius, whatIsGround);
        Vector2 hitPosition = Vector2.zero;
        // walk collisions and see if the ground is ever in there
        contactPoints.Clear();
        tilemapCollider.GetContacts(contactPoints);
        foreach (ContactPoint2D contactPoint in contactPoints)
        {
            hitPosition.x = contactPoint.point.x + (0.1f * contactPoint.normal.x);
            hitPosition.y = contactPoint.point.y + (0.1f * contactPoint.normal.y);
            Vector3Int cellPosition = tilemap.WorldToCell(hitPosition);
            //debug.transform.position = new Vector3(hitPosition.x, hitPosition.y, 0);  //tilemap.CellToWorld(cellPosition);
            TileBase t = tilemap.GetTile(cellPosition);
            if (t != null)
            {
                if (tilemap.GetSprite(cellPosition).name.IndexOf("spike") > -1)
                {
                    Die();
                    break;
                }
            }
        }

        moveInput = Input.GetAxis("Horizontal"); //unity built in fx; moveinput = 1 for right, moveinput = -1 for left
        rb.velocity = new Vector2(moveInput * speed, rb.velocity.y);
        anim.SetFloat("Speed", Mathf.Abs(moveInput));

        if (facingRight == false && moveInput > 0)
        {
            Flip();
        }
        else if (facingRight == true && moveInput < 0)
        {
            Flip();
        }

        if (moveInput > 0 && Input.GetKeyDown(KeyCode.RightArrow))
        {
            anim.Play("Run");
        }
        else if (moveInput < 0 && Input.GetKeyDown(KeyCode.LeftArrow))
        {
            anim.Play("Run");
        }
    }

    void Update()
    {
        if (isGrounded == true)
        {
            extraJumps = extraJumpsValue;
        }
        //if (Input.GetKeyDown(KeyCode.L))
        //{
        //    StartCoroutine(DataHandler.Post(DataHandler.s_PlayerID + " Total Attempt: " + DataHandler.s_TotalAttempt));
        //}

        if (Input.GetKey(KeyCode.Space) && extraJumps > 0)
        {
            rb.velocity = Vector2.up * jumpForce;
            anim.Play("Jump");
            extraJumps--;
        }
        else if (Input.GetKey(KeyCode.Space) && extraJumps == 0 && isGrounded == true)
        {
            rb.velocity = Vector2.up * jumpForce;
            anim.Play("Jump");
        }
        DetectKeyPress();
        print(keycountA_f);
    }

    void Flip()
    {
        facingRight = !facingRight;
        Vector3 Scaler = transform.localScale;
        Scaler.x *= -1;
        transform.localScale = Scaler;
    }

    public void Die()
    {
        print(attempts + "attempts");
        StartCoroutine(StopMovement());
        rb.position = spawnPoint;
        deadFlashingTimer = 0.5f;
        attempts++;
        attemptTxt.text = attempts.ToString();
        DataHandler.s_TotalAttempt += attempts;
        if (attempts >= attemptsLimit)
        {
            AttemptLimit();
        }
        //DataHandler.s_TotalAttempt++;
        //if (attempts == 0)
        //{
        //    if (currLevel != 3)
        //    {
        //        SceneManager.LoadScene("LevelCompleteFail");
        //    }
        //    else
        //    {
        //        SceneManager.LoadScene("End");
        //    }
        //}
    }

    void AttemptLimit()// when attempt limit hits
    {
        switch (whatStage)
        {
            case 1:
                StartCoroutine(FlashPause(false));
                break;
            case 2:
                StartCoroutine(FlashPause(true));
                LLB.GenerateLevel();
                rb.position = spawnPoint;
                attempts = 0;
                break;
            case 3:
                StartCoroutine(FlashPause(false));
                break;
        }
    }
    public static void RespawnWithNewLevel()
    {
        GameObject.FindObjectOfType<PlayerController>().Die();
        GameObject.FindObjectOfType<PlayerController>().CallFlashStart();
        GameObject.FindObjectOfType<PlayerController>().PlayerResetsLevel();
    }

    public void CallFlashStart()
    {
        StartCoroutine(FlashStart());
    }
    private void OnTriggerEnter2D(Collider2D collision)
    {
        Debug.Log(collision);
        if (collision.tag == "Portal"/* && currLevel != 3*/)
        {

            switch (gameLevel)
            {
                case 0:
                    GetTimeData();
                    SendKeyInputs();
                    SceneManager.LoadScene(SceneManager.GetActiveScene().buildIndex + 1);
                    break;
                case 1:
                    levelCounter++;
                    StartCoroutine(FlashStart());
                    LLB.GenerateLevel();
                    rb.position = spawnPoint;
                    attempts = 0;
                    attemptTxt.text = attempts.ToString();
                    GetTimeData();
                    LevelEndSend();
                    if (levelCounter >= 10)
                    {
                        SceneManager.LoadScene(SceneManager.GetActiveScene().buildIndex + 1);
                    }
                    break;
                case 2:
                    GetTimeData();
                    SendKeyInputs();
                    SceneManager.LoadScene("End");
                    break;
            }
        }
        else
        {
            SceneManager.LoadScene("End");
        }
    }

    public void PlayerResetsLevel()
    {
        levelCounter++;
        //StartCoroutine(DataHandler.Post(DataHandler.s_PlayerID + " Resets level"));
        StartCoroutine(DataHandler.PostLevelData(DataHandler.s_PlayerID + " Total Attempt: " + DataHandler.s_TotalAttempt + " Level Reset",
            DataHandler.s_PlayerID + " Current Level " + currentLevel + gameLevel + "\n" + "Time taken: " + TimeTracker.localTime + " Level Reset"));
        TimeTracker.localTime = 0;
    }
    void GetTimeData()
    {
        StartCoroutine(DataHandler.PostLevelData(DataHandler.s_PlayerID + " Total Attempt: " + DataHandler.s_TotalAttempt, 
            DataHandler.s_PlayerID + " Current Level " + currentLevel + gameLevel + "\n" + "Time taken: " + TimeTracker.localTime));
        TimeTracker.localTime = 0;
    }

    IEnumerator StopMovement()
    {
        cue.text = "GET READY 3 !";
        speed = 0;
        jumpForce = 0;
        yield return new WaitForSeconds(1);
        cue.text = "GET READY 2 !";
        yield return new WaitForSeconds(1);
        cue.text = "GET READY 1 !";
        yield return new WaitForSeconds(1);
        cue.text = "GO GO GO !!!";
        speed = 3.5f;
        jumpForce = 11;
        yield return new WaitForSeconds(2);
        cue.text = " ";
    }
    IEnumerator FlashPause(bool levelGen)
    {
        if (levelGen)
        {
            if (levelCounter <= 10)
            {
                attemptLimitUI.SetActive(true);
                yield return new WaitForSeconds(5);
                attemptLimitUI.SetActive(false);
                StartCoroutine(StopMovement());
                levelCounter++;
            }
            else
            {
                attemptLimitUI.SetActive(true);
                yield return new WaitForSeconds(5);
                attemptLimitUI.SetActive(false);
                SceneManager.LoadScene(SceneManager.GetActiveScene().buildIndex + 1);
            }
        }
        if(!levelGen)
        {
            print("in 1");
            attemptLimitUI.SetActive(true);
            yield return new WaitForSeconds(5);
            attemptLimitUI.SetActive(false);
            SceneManager.LoadScene(SceneManager.GetActiveScene().buildIndex + 1);
        }

    }
    IEnumerator FlashStart()
    {
        StartTextUI.SetActive(true);
        yield return new WaitForSeconds(5);
        StartTextUI.SetActive(false);
        StartCoroutine(StopMovement());
    }
    /// <summary>
    /// Detect key press
    /// </summary>
    void DetectKeyPress()
    {
        if (Input.GetKey(KeyCode.A))
        {
            keys[KeyCode.A].tempTime = Time.realtimeSinceStartup;
        }
        if (Input.GetKey(KeyCode.D))
        {
            //keycountD++;
            keys[KeyCode.D].tempTime = Time.realtimeSinceStartup;
        }
        if (Input.GetKey(KeyCode.LeftArrow))
        {
            keys[KeyCode.LeftArrow].tempTime = Time.realtimeSinceStartup;
        }
        if (Input.GetKey(KeyCode.RightArrow))
        {
            //keycountD++;
            keys[KeyCode.RightArrow].tempTime = Time.realtimeSinceStartup;
        }
        if (Input.GetKey(KeyCode.Space))
        {
            //keycountSpace++;
            keys[KeyCode.Space].tempTime = Time.realtimeSinceStartup;
        }


        if (Input.GetKeyUp(KeyCode.A))
        {
            float t = Time.realtimeSinceStartup;
            ++keys[KeyCode.A].times;
            //keys[KeyCode.A].duration += t - keys[KeyCode.A].tempTime;
            dH.keyInputs += "A key press for " + (t - keys[KeyCode.A].tempTime) + "\n";
            lineCounter++;
            keys[KeyCode.A].tempTime = 0;
            
        }
        if (Input.GetKeyUp(KeyCode.LeftArrow))
        {
            float t = Time.realtimeSinceStartup;
            ++keys[KeyCode.LeftArrow].times;
            //keys[KeyCode.A].duration += t - keys[KeyCode.A].tempTime;
            dH.keyInputs += "LeftArrow key press for " + (t - keys[KeyCode.LeftArrow].tempTime) + "\n";
            lineCounter++;
            keys[KeyCode.LeftArrow].tempTime = 0;

        }
        if (Input.GetKeyUp(KeyCode.D))
        {
            float t = Time.realtimeSinceStartup;
            ++keys[KeyCode.D].times;
            //keys[KeyCode.D].duration += keys[KeyCode.D].tempTime - t;
            dH.keyInputs += "D key press for " + (t - keys[KeyCode.D].tempTime) + "\n";
            lineCounter++;
            keys[KeyCode.D].tempTime = 0;
        }
        if (Input.GetKeyUp(KeyCode.RightArrow))
        {
            float t = Time.realtimeSinceStartup;
            ++keys[KeyCode.RightArrow].times;
            //keys[KeyCode.D].duration += keys[KeyCode.D].tempTime - t;
            dH.keyInputs += "RightArrow key press for " + (t - keys[KeyCode.RightArrow].tempTime) + "\n";
            lineCounter++;
            keys[KeyCode.RightArrow].tempTime = 0;
        }
        if (Input.GetKeyUp(KeyCode.Space))
        {
            float t = Time.realtimeSinceStartup;
            ++keys[KeyCode.Space].times;
            keys[KeyCode.Space].duration += keys[KeyCode.Space].tempTime - t;
            dH.keyInputs += "Space press for " + (t - keys[KeyCode.Space].tempTime) + "\n";
            lineCounter++;
            keys[KeyCode.Space].tempTime = 0;
        }
    }
    void SendKeyInputs()
    {
        if(lineCounter >= 100)
        {
            StartCoroutine(DataHandler.PostInputs(index + " Data set for "+ DataHandler.s_PlayerID +" " + dH.keyInputs));
            index++;
            lineCounter = 0;
            dH.keyInputs = "";
        }
    }
    void LevelEndSend()
    {
        StartCoroutine(DataHandler.PostInputs(index + "Data set for " + DataHandler.s_PlayerID + " " + dH.keyInputs + " end of level."));
        index++;
        lineCounter = 0;
        dH.keyInputs = "";
    }
}