using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class RayCaster : MonoBehaviour
{
    [SerializeField] float distance;

    // Start is called before the first frame update
    void Start()
    {

    }

    // Update is called once per frame
    void Update()
    {
        GenerateRay();
    }

    private void FixedUpdate()
    {
        //GenerateRay();
    }

    public void GenerateRay()
    {
        int layermask = 1 << 8;
        layermask = ~layermask;

        RaycastHit2D hitUp = Physics2D.Raycast(transform.position, transform.up, distance, layermask); // 0 Degree
        if (hitUp.collider != null)
        {
            RayHitDetection(hitUp);
        }

        RaycastHit2D hitUpLeft = Physics2D.Raycast(transform.position, -transform.right + transform.up, distance, layermask); //-45 Degree
        if (hitUpLeft.collider != null)
        {
            RayHitDetection(hitUpLeft);
        }

        RaycastHit2D hitUpRight = Physics2D.Raycast(transform.position, transform.right + transform.up, distance, layermask); // 45 Degree
        if (hitUpRight.collider != null)
        {
            RayHitDetection(hitUpRight);
        }

        RaycastHit2D hitDown = Physics2D.Raycast(transform.position, -transform.up, distance, layermask); // 180
        if (hitDown.collider != null)
        {
            RayHitDetection(hitDown);
        }

        RaycastHit2D hitDownLeft = Physics2D.Raycast(transform.position, -transform.right - transform.up, distance, layermask); // -135 degree
        if (hitDownLeft.collider != null)
        {
            RayHitDetection(hitDownLeft);
        }

        RaycastHit2D hitDownRight = Physics2D.Raycast(transform.position, transform.right - transform.up, distance, layermask); // 135 degree
        if (hitDownRight.collider != null)
        {
            RayHitDetection(hitDownRight);
        }

        RaycastHit2D hitLeft = Physics2D.Raycast(transform.position, -transform.right, distance, layermask); // -90 degree
        if (hitLeft.collider != null)
        {
            RayHitDetection(hitLeft);
        }

        RaycastHit2D hitRight = Physics2D.Raycast(transform.position, transform.right, distance, layermask); // 90 degree
        if (hitRight.collider != null)
        {
            RayHitDetection(hitRight);
        }


        #region unused
        //RaycastHit rayHit;
        //Vector3 dir = new Vector3(1, 1, 0);
        //if (Physics.Raycast(transform.position, -transform.up, out rayHit, distance, layermask))
        //{
        //    RayHitDetection3D(rayHit);
        //
        //}
        //for (int i = -1; i <= 1; ++i)
        //{
        //    for (int j = -1; j <= 1; ++j)
        //    {
        //        if (i == 0 && j == 0)
        //            continue;
        //
        //        if (Physics.Raycast(transform.position, new Vector3(dir.x * i, dir.y * j, 0), out rayHit, distance, layermask))
        //        {
        //            RayHitDetection3D(rayHit);
        //        }
        //
        //    }
        //}
        #endregion
    }

    void RayHitDetection(RaycastHit2D rayHit2D)
    {
        int whatLayer = rayHit2D.collider.gameObject.layer;

        switch (whatLayer)
        {
            case 6:
                print("HitGround");
                break;
            case 7:
                print("HitSpike");
                break;
            case 9:
                print("HitEnd");
                    break;
        }

    }
    //void RayHitDetection3D(RaycastHit rayHit )
    //{
    //    int whatLayer = rayHit.collider.gameObject.layer;
    //    print(whatLayer + "Layer");
    //    //else
    //    //{
    //    //    string whatLayer = rayHit2D.collider.gameObject.layer.ToString();
    //    //    switch (whatLayer)
    //    //    {
    //    //        case "Ground":
    //    //            print("HitGround");
    //    //            break;
    //    //        case "Spike":
    //    //            print("HitSpike");
    //    //            break;
    //    //    }
    //    //}
    //}
}
