library(tidyverse)
library(lubridate)

occupancy <- read_csv('data/datatraining.txt', skip = 1,
                      col_names = c('row', 'date', 'temp', 'humidity', 'light',
                                   'co2', 'humidity_ratio', 'occupancy'))
occupancy %>%
  mutate(day = wday(date),
         hour = hour(date)) %>%
  select(-date) %>%
  write_csv('data/occupancy.csv')