# FitLight

In this project, we open-source the source code and datasets of our FitLight approach and upload the datasets.

## Check List

Readme File ✔

Source Code ✔

Synthetic/Real-world Traffic Datasets ✔

## Requirements
Under the root directory, execute the following conda commands to configure the Python environment.
``conda create --name <new_environment_name> --file requirements.txt``

``conda activate <new_environment_name>``

### Simulator installation
Our experiments are implemented on top of the traffic simulator Cityflow. Detailed installation guide files can be found in https://cityflow-project.github.io/

#### 1. Install cpp dependencies
``sudo apt update && sudo apt install -y build-essential cmake``

#### 2. Clone CityFlow project from github
``git clone https://github.com/cityflow-project/CityFlow.git``

#### 3. Go to CityFlow project’s root directory and run
``pip install .``

#### 4. Wait for installation to complete and CityFlow should be successfully installed
``import cityflow``

``eng = cityflow.Engine``

## Run the code
#### Execute the following command to run the experiment over the specified dataset.
``python train.py --d <dataset_name>``

## Datasets
For the experiments, we used both synthetic and real-world traffic datasets provided by https://traffic-signal-control.github.io/dataset.html.
| Dataset Name | Dataset Type | # of intersections |
| :-----------: | :-----------: | :-----------: |
| Syn1 | Synthetic | 1×3 |
| Syn2 | Synthetic | 2×2 |
| Syn3 | Synthetic | 3×3 |
| Syn4 | Synthetic | 4×4 |
| Hangzhou1 | Real-world | 4×4 |
| Hangzhou2 | Real-world | 4×4 |
| Jinan1 | Real-world | 4×3 |
| Jinan2 | Real-world | 4×3 |
| Jinan3 | Real-world | 4×3 |