# Evaluation Metrics

## Commonsense Constraints

|                           | Environment Constraints                                                 | Semantics                                                                                                                                                                                                |
| ------------------------- | ----------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Cross-city Transportation | Intercity transportation events must occur.                             | The first event and last event must be cross-city transports.                                                                                                                                           |
|                           | Available Trains or Airplanes across cities.                            | The provied TrainID/FlightID, origin and destination shoud be valid in the travel sandbox.                                                                                                              |
|                           | Correct information of price, duration.                                 | The price and duration information should match the travel sandbox.                                                                                                                                      |
|                           | Detailed cost on inter-city transportation                              | The travel plan should provide the number of tickets and cost of each inter-city-transportation activity.$cost=price*tickets$                                                                          |
| Inner-city Transportation | Available Metro, Taxi or Walking between different positions.           | The provided routes should be valid in the travel sandbox.                                                                                                                                               |
|                           | Correct information of price, distance, and duration.                   | The price, distance and duration information should match the travel sandbox.                                                                                                                            |
|                           | Detailed cost on inner-city transportation                              | The travel plan should provide the number of tickets/cars and cost of each inter-city-transportation activity. The taxi capacity is 4 people per car.$cost=price*tickets$, $cost=price*cars$         |
| Attractions               | Available attractions in the target city                                | The provided attractions should be valid in the travel sandbox.                                                                                                                                          |
|                           | Visiting the attractions in their openting time.                        | Visiting the attractions in their openting time.                                                                                                                                                         |
|                           | Correct information of price.                                           | The price information should match the travel sandbox.                                                                                                                                                   |
|                           | Detailed cost of attraction activity.                                   | The travel plan should provide the number of tickets and cost of each attraction activity.$cost=price*tickets$                                                                                         |
|                           | Attraction choices should not be repeated throughout the trip.          | Attraction choices should not be repeated throughout the trip.                                                                                                                                           |
| Restaurants               | Available restaurants in the target city                                | The provided restaurants should be valid in the travel sandbox.                                                                                                                                          |
|                           | Visiting the restaurants in their openting time.                        | Visiting the restaurants in their openting time.                                                                                                                                                         |
|                           | Correct information of price.                                           | The price information should match the travel sandbox.                                                                                                                                                   |
|                           | Detailed cost of restaurant activity.                                   | The travel plan should provide the number of tickets and cost of each restaurant activity.$cost=price*tickets$                                                                                         |
|                           | Restaurant choices should not be repeated throughout the trip.          | Restaurant choices should not be repeated throughout the trip.                                                                                                                                           |
|                           | Breakfast, lunch, and dinner are served at their designated meal times. | Breakfast starts no later than 9:00 and ends no earlier than 06:00. Lunch starts no later than 14:00 and ends no earlier than 11:00. Dinner starts no later than 17:00 and ends no earlier than 20:00. |
| Accommodation             | Available accommodation in the target city.                             | The provided accommodations should be valid in the travel sandbox.                                                                                                                                       |
|                           | Correct room information of price and type.                             | The price and room type information should match the travel sandbox.                                                                                                                                     |
|                           | Detailed cost of accommodation activity.                                | The travel plan should provide the number of rooms and cost of each accommodation activity.$cost=price*rooms$                                                                                          |
|                           | Accomondation is necessary for trips longer than one day                | We need a hotel for a trip more than one day.                                                                                                                                                            |
| Time                      | Detailed duration information of each activity.                         | The travel plan should provide the starting time and ending time of each activity. The ending time must be later than the starting time.                                                                 |
|                           | The given activity events occur in chronological order.                 | Travel Plan lists activities in chronological order. The starting time of each activity should be no earlier than the ending time of the transportation that reaches its position.                       |
| Space                     | Events at different positions should provide transport information.     | If the current position is different from the previous event position, the transportation route from the previous event position to the current position must be given.                                  |

## Personal Constraints
