import json
import json
from tqdm import tqdm
import os
from http import HTTPStatus
import time
import random
import base64
import openai

openai_api_key = ''
openai.api_key = openai_api_key

def get_prompt(data):
    question = data['question']
    options = data['options']
    length = len(options)
    choices = ''
    if length == 2:
        choices = 'A, B'
    elif length == 3:
        choices = 'A, B, C'
    elif length == 4:
        choices = 'A, B, C, D'
    elif length == 5:
        choices = 'A, B, C, D, E'
    system_prompt = "Give a single choice question with several options, you need to select the only one answer."
    prompt =  "Question: " + question+'\n' + 'Options: \n'
    if length == 2:
        caption1 = options['A']
        caption2 = options['B']
        prompt += f"(A) {caption1}\n(B) {caption2}\nOnly output one answer."
    elif length == 3:
        caption1 = options['A']
        caption2 = options['B']
        caption3 = options['C']
        prompt += f"(A) {caption1}\n(B) {caption2}\n(C) {caption3}\nOnly output one answer."
    elif length == 4:
        caption1 = options['A']
        caption2 = options['B']
        caption3 = options['C']
        caption4 = options['D']
        prompt += f"(A) {caption1}\n(B) {caption2}\n(C) {caption3}\n(D) {caption4}\nOnly output one answer."
    elif length == 5:
        caption1 = options['A']
        caption2 = options['B']
        caption3 = options['C']
        caption4 = options['D']
        caption5 = options['E']
        prompt += f"(A) {caption1}\n(B) {caption2}\n(C) {caption3}\n(D) {caption4}\n(E) {caption5}\nOnly output one answer."
    return prompt

batch_size = 1
inp_path = './MMComposition_finalized/images'
with open('./MMComposition_finalized/questions.json','r') as f:
    data = json.load(f)

img_keys = sorted(os.listdir(inp_path),key=lambda x:int(x.split('.')[0]))
length = len(img_keys)
print(length)

end = 4342 // batch_size
img_li = img_keys
res_dict = {}


start = 0 // batch_size
for i in tqdm(range(start,end)):
    prompt = get_prompt(data[i])
    response = openai.ChatCompletion.create(
        model='gpt-3.5-turbo',
        messages=[
            {"role": "user", "content": f"{prompt}"},
        ],
        temperature=0,
        )
    res_dict[img_li[batch_size*i]] = response.choices[0].message.content

with open('one_result_gpt3.json','w') as f:
    json.dump(res_dict,f,indent=4)