function [grad,D] = logistic_grad(z, b)
%Requirement: b in {-1,1}
	tmp = 1./(1+exp(-(b.*z)));
	grad = (tmp - 1) .* b;
	if (nargout == 2)
		D = tmp .* (1 - tmp);
	end
end
