function [wout, gout, stepsize, Awout] = linesearch(loss, grad, A, b, sigma, w, p, norm_p, g, obj, Aw, Ap, init_step, eps_l2)
	backtracking_iter = 20;
	stepsize = init_step;
    RHS = sigma * norm_p/2;

	succeed = 0;
   
	for i=1:backtracking_iter
		wout = w + stepsize * p;
		Awout = Aw + stepsize * Ap;
		[newloss, ~] = loss_fun_and_grad(loss, grad, wout, A, b, eps_l2, Awout);
		newobj = newloss;
		if (newobj < obj - stepsize^2 * RHS)
			succeed = 1;
			break;
		end
		stepsize = stepsize / 2;
	end
    
	if (succeed == 0)
		stepsize = 0;
		wout = w;
		gout = g;
		return;
	else
		[~,~,gout] = loss_fun_and_grad(loss, grad, wout, A, b, eps_l2, Awout);%Computing the gradient needs to run through the whole A, but other operations don't, so avoid it unless necessary
	end
end