function step = initstep_cal(norm_p, descent, Ap, grad, z, b, L)
	%p = w1 - w0, z = Aw1
	%If L is given, it should be an estimate of the (local or global) Lipschitz constant of the gradient
	%If it is not given, we use the D entry from grad to get the real Hessian for the estimate

	if (nargin == 7)
% 		grad_coeff = grad(z,b);
		denominator = L*(norm_p);
	else
		[~, D] = grad(z,b);
		denominator = Ap'*(D .* Ap);
	end
	numerator = -descent;
	step = numerator / denominator;

end
