wndws = 1;

datasets = {'colon-cancer','duke', 'gisette_scale', 'leukemia','E2006-tfidf','E2006-log1p','rcv1','news20','webspam'};
[parentdir,~,~] = fileparts(pwd);

if wndws
    dir_datasets = [parentdir '\datasets'];
else
    dir_datasets = [parentdir '/datasets'];
end

for dataset = {'colon-cancer','duke'}
    load(fullfile(dir_datasets,[dataset{1} '_train.mat']),'A');
    [normA,timeA] = getnorm(A);
    filename = ['norms_' dataset{1} '.mat'];
    save(filename,'normA','timeA');
end



function [normA,timeA] = getnorm(A)
[m,n] = size(A);

eval_timer_norm = tic;
    if (m > n)
        S = @(x) A' * (A*x);
        len = n;
    else
        S = @(x) A * (A'*x);
        len = m;
    end
    opt.Tolerance = 1e-3;
    normA = eigs(S, len, 1, 'lr', opt); %norm(A)^2

timeA = toc(eval_timer_norm);
end