# Define agent types and ranges
agent_types=("orchestrator")
n_agents_range=(2 3 4)
budget_range=(100 200 300 500 1000)  # Budget values to test
model_name=meta-llama/Llama-3.1-70B-Instruct

# Run experiments for each agent type, number of agents, and budget
for agent_type in "${agent_types[@]}"; do
    echo "Running experiments for agent type: $agent_type"
    for n_agents in "${n_agents_range[@]}"; do
        echo "Running with $n_agents agents..."
        for budget in "${budget_range[@]}"; do
            echo "Running with budget: $budget"
            python my_agent/run.py -t "$agent_type" -n "$n_agents" --level all --budget "$budget" --model "$model_name"
        done
    done
done
