#!/bin/bash
# Run single experiment
agent_type=planner
n_agents=3  # 3 executors (agent 0 is planner)

# Different executor models for different agents
executor_models="gpt-4o-mini,meta-llama/Llama-3.1-70B-Instruct,Qwen/Qwen2.5-Coder-32B-Instruct"

echo "Running experiment with:"
echo "Agent type: $agent_type"
echo "Number of agents: $n_agents"
echo "Executor models: $executor_models"

python experiment2/my_agent/run.py -t "$agent_type" -n "$n_agents" --level level_8 --model "gpt-4o-v2" -exs "$executor_models" -ct 4.0