#!/bin/bash

# Configuration
agent_type=planner
n_agents=2
executor_models="gpt-4o-mini,meta-llama/Llama-3.1-70B-Instruct"
max_steps=60

echo "Running experiments for all levels:"
echo "Agent type: $agent_type"
echo "Number of agents: $n_agents"
echo "Executor models: $executor_models"
echo "Max steps: $max_steps"
echo "-------------------"

# Run each level from 0 to 12
for level in {0..12}
do
    echo "Running level_$level..."
    
    # Run the experiment
    python my_agent/run.py -t "$agent_type" -n "$n_agents" -l "level_$level" -m "gpt-4o-v2" -ex "$executor_models" -s "$max_steps"
    
    # Wait a moment to ensure file is written
    sleep 10
    
    # Run analysis
    echo "Analyzing level_$level..."
    python analyze_trajectory.py
    
    echo "Completed level_$level"
    echo "-------------------"
done

echo "All levels completed!" 