orchestrator_pre_prompt = """You are the orchestrator agent in a team of {total_agents}. 
Your task is to generate a plan for each of the executor agents to complete the dishes in the environment in time. 
You can only control the actions for the executor agents. 
Executor agents can only execute 1 action at a time.
You can parallelize actions for the executor agents to complete the dishes faster and you can also plan ahead.

Game Rules: 
{rules}

--------------------------------------------
Example:
"""


orchestrator_post_prompt = """
End of example
--------------------------------------------

Environment state: 
{environment}

-action:
"""


orchestrator_examples = [
("user",
 """
Environment state:
-current game level: level_7
current dishes:
    -name: onionBroccoliCheeseSoup lifetime: 3
    -name: onionPotatoCarrotSoup lifetime: 8
    -name: onionBroccoliCheeseSoup lifetime: 10


current game step: 20
maximum game steps: 60

-agent state:
    -at(agent0, pot0)
    -hold(agent0, None)
    -at(agent1, storage0)
    -hold(agent1, potato)
    -at(agent2, servingtable0)
    -hold(agent2, None)

-kitchen state:
    -inside(storage0, None)
    -inside(servingtable0, None)
    -inside(pot0, onionBroccoliCheeseSoup)
    -inside(pot1, onion)

-accomplished task:

Your plan: 
"""),
("assistant",
"We just made onionBroccoliCheeseSoup in pot0 and need to put it in servingtable0. We are also making onionPotatoCarrotSoup in pot1. agent0 needs to put the onionBroccoliCheeseSoup in servingtable0. agent1 needs to take the potato to pot1. agent2 should go to storage0 to get carrot for onionPotatoCarrotSoup"
),
("user",
 """
Environment state:
-current game level: level_7
current dishes:
    -name: onionBroccoliCheeseSoup lifetime: 2
    -name: onionPotatoCarrotSoup lifetime: 7
    -name: onionBroccoliCheeseSoup lifetime: 9


current game step: 21
maximum game steps: 60

-agent state:
    -at(agent0, pot0)
    -hold(agent0, onionBroccoliCheeseSoup)
    -at(agent1, blender0)
    -hold(agent1, potato)
    -at(agent2, storage0)
    -hold(agent2, None)

-kitchen state:
    -inside(storage0, None)
    -inside(servingtable0, None)
    -inside(pot0, None)
    -inside(pot1, onion)

-accomplished task:

Your plan:
"""),
("assistant",
"onionBroccoliCheeseSoup is held by agent0. We need to put it in servingtable0. We also need to put potato in blender0 for onionPotatoCarrotSoup. And need to get the ingredients for onionPotatoCarrotSoup. agent0 should put onionBroccoliCheeseSoup in servingtable0. agent1 should put potato in pot1. agent2 needs to get carrot from storage0 for onionPotatoCarrotSoup."),
]


