planner_info_prompt = """In this game, there are {total_num_agents} agents available, so you should generate a plan for all the {total_num_agents} agents.
Your task is to generate a plan for all the agents given the state of the game.

Model Cost Information (per million tokens):
{model_costs}

Historical Performance Analysis:
{historical_summary}

Use this historical performance data to:
1. Assign tasks to agents based on their past success rates
2. Avoid known inefficient patterns and actions
3. Leverage successful strategies from previous runs
4. Consider each agent's strengths and weaknesses

Every action requires querying a language model, which has different costs for input and output tokens.
Consider these costs when generating plans:
1. Use cheaper models for simpler tasks
2. Balance task complexity with model costs
3. Minimize unnecessary actions to reduce token usage
4. Consider the total cost of completing each dish

Generate a CONCISE, one-paragraph plan that efficiently assigns tasks to all agents to complete the dishes.
Your plan should prioritize dishes based on time constraints, assign specific roles to each agent,
and coordinate agent movements to avoid inefficiencies.

Remember that your plan will be triggered at the start and whenever a dish is added, removed, or completed.
"""

planner_examples = [
    ("user", 
"""
----- START OF EXAMPLE -----
There are 2 agents available.
This is an example you can use as a reference for a different level.

-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 17
current game step: 0
maximum game steps: 30

-agent state:
at(agent0, servingtable0)
hold(agent0, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-budget: $0/1000

-accomplished task:

-plan:
"""),

("assistant",
 """
To start solving the problem, we need to get the base ingredients from the storage. Since all agents are initially at the servingtable, we'll need to move them to the storage first. Here's a plan for all 2 agents:                           
1. **Move agents to storage:**
   - Agent0: goto_agent0_storage0
   - Agent1: goto_agent1_storage0

This plan aims to get all agents to the storage location so they can start retrieving base ingredients (salmon, flour, pork) for cooking.

"""),

("user", """
-previous actions:
 agent0: goto_agent0_storage0
 agent1: goto_agent1_storage0
 
-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 17
current game step: 0
maximum game steps: 30

-agent state:
at(agent0, storage0)
hold(agent0, None)
at(agent1, storage0)
hold(agent1, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)
 
-budget: $6/1000

-accomplished task:

-plan:

"""
 ),

 ("assistant", """As we are making the beefMeatcake, we need to get the base ingredients from the storage. Agents are now in the storage and need to get the ingredients: beef and flour.

 **Get ingredients:**
   - Agent0: get_agent0_beef_storage0
   - Agent1: get_agent1_flour_storage0
"""),

("user", " ----- END OF EXAMPLE -----")

]


executor_info_prompt = """In this game, There are {total_num_agents} agents available, you are agent{agent_id} and you can only control and the actions for this agent. 
If you try to execute an action for different agent, it will cause an error.
You are given a plan for all the agents, and you should generate the action for the agent{agent_id}."""

executor_examples = [
("user", 
"""----- START OF EXAMPLE -----
There are 2 agents available. You are controlling agent0. You can execute 1 action at a time.
This is an example you can use as a reference for a different level.

-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 17
current game step: 0
maximum game steps: 30

-agent state:
at(agent0, servingtable0)
hold(agent0, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:

-plan:To start solving the problem, we need to get the base ingredients from the storage. Since all agents are initially at the servingtable, we'll need to move them to the storage first. Here's a plan for all 2 agents:

1. **Move agents to storage:**
   - Agent0: goto_agent0_storage0
   - Agent1: goto_agent1_storage0

This plan aims to get all agents to the storage location so they can start retrieving base ingredients (salmon, flour, pork) for cooking.

-action:
"""),

("assistant", "goto_agent0_storage0"),

("user", 
"""-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 17
current game step: 0
maximum game steps: 30

-agent state:
at(agent0, servingtable0)
hold(agent0, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:

-plan:As we are making the beefMeatcake, we need to get the base ingredients from the storage. Agents are now in the storage and need to get the ingredients: beef and flour.

 **Get ingredients:**
   - Agent0: get_agent0_beef_storage0
   - Agent1: get_agent1_flour_storage0

-action:
"""),

("assistant", "get_agent0_beef_storage0"),

("assistant", "----- END OF EXAMPLE -----"),
]