debate_pre_prompt = """You are agent{agent}, and there are {total_agents} agents in the environment. 
You are in a debate with the other agents. You have {num_debate_rounds} rounds to debate.
You need to coordinate with the other agents to complete as many current dishes as possible in time.
You can only control the actions for agent{agent}.
Your task is to coordinte with the other agents which actions to take to complete the dishes.
You can parallelize actions for the agents to complete the dishes faster and you can also plan ahead. Avoid using the same tools at the same time. 
Return your next thought for agent{agent}.

Game Rules: 
{rules}

--------------------------------------------
Example (from another level):

"""

debate_post_prompt = """
Environment state: 
{environment}

{thoughts}

Your next thought[write only the thought]:"""


debate_examples = [

("user", 
"""
Environment state:
-current game level: level_7
current dishes:
    -name: onionBroccoliCheeseSoup lifetime: 8
    -name: onionPotatoCarrotSoup lifetime: 10
    

current game step: 12
maximum game steps: 60

-agent state:
    -at(agent0, servingtable0)
    -hold(agent0, None)
    -at(agent1, servingtable0)
    -hold(agent1, None)
    -at(agent2, servingtable0)
    -hold(agent2, None)

-kitchen state:
    -inside(storage0, None)
    -inside(servingtable0, None)
    -inside(pot0, None)
    -inside(pot1, None)

-accomplished task:

In round 0, you thought: 
- agent0 said: We will make onionBroccoliCheeseSoup and onionPotatoCarrotSoup second. We need to get onion, broccoli, and cheese from storage0. I will go get onion and the others agents can get broccoli and cheese. After that, we will put it in pot0.
Other agents thoughts in round 0:
-agent1 said: We need to make the onionBroccoliCheeseSoup and onionPotatoCarrotSoup. Let's start with onionBroccoliCheeseSoup as it has smaller lifetime value. We need to get onion, broccoli, and cheese from storage0. Then we need to put onion, broccoli, and cheese into pot0. After that, we need to activate pot0 to make onionBroccoliCheeseSoup. Finally, we need to put onionBroccoliCheeseSoup into servingtable0.
-agent2 said: Since onionBroccoliCheeseSoup has smaller lifetime value, we should start with it. We need to get onion, broccoli, and cheese from storage0. Then we need to put onion, broccoli, and cheese into pot0. After that, we need to activate pot0 to make onionBroccoliCheeseSoup. Finally, we need to put onionBroccoliCheeseSoup into servingtable0.

Your next thought[write only the thought]:
"""),

("assistant",
"""
We need to make as many dishes as possible. We start with onionBroccoliCheeseSoup as it has smaller lifetime value. We need to get onion, broccoli, and cheese from storage0. But we can only get 1 at a time. I can take onion, agent1 can take broccoli, and agent2 can take cheese. After that, we need to put onion, broccoli, and cheese into pot0. After that, one can activate pot0, while the other start getting the ingredients for onionPotatoCarrotSoup in pot1.
"""
 ),

("user", 
"""
In round 1, you thought: 
- agent0 said: We need to make as many dishes as possible. We start with onionBroccoliCheeseSoup as it has smaller lifetime value. We need to get onion, broccoli, and cheese from storage0. But we can only get 1 at a time. I can take onion, agent1 can take broccoli, and agent2 can take cheese. After that, we need to put onion, broccoli, and cheese into pot0. After that, one can activate pot0, while the other start getting the ingredients for onionPotatoCarrotSoup in pot1.
Other agents thought in round 1: 
- agent1 said: We are going to make onionBroccoliCheeseSoup first. As agent0 suggested, we can divide the tasks. I will get broccoli from storage0. Agent0 will get onion and agent2 will get cheese. After that, we need to put ingredionts into pot0. Then we need to activate pot0 to make onionBroccoliCheeseSoup. Finally, we need to put onionBroccoliCheeseSoup into servingtable0. 
- agent2 said: We are making onionBroccoliCheeseSoup. I will get cheese from storage0. Agent0 will get onion and agent1 will get broccoli. After that, we need to put ingredients into pot0. Then one will activate pot0 to make onionBroccoliCheeseSoup. Then, I will continue to get ingredients for onionPotatoCarrotSoup.
"""),

("assistant",
"""
We agreed that I will get onion, agent1 will get broccoli, and agent2 will get cheese. After that, we need to put ingredients into pot0. After that, one can activate pot0, while the other start getting the ingredients for onionPotatoCarrotSoup in pot1.
"""),


("user", 
"""
Environment state:
-current game level: level_7
current dishes:
    -name: onionBroccoliCheeseSoup lifetime: 7
    -name: onionPotatoCarrotSoup lifetime: 9
    

current game step: 13
maximum game steps: 60

-agent state:
    -at(agent0, storage0)
    -hold(agent0, None)
    -at(agent1, storage0)
    -hold(agent1, None)
    -at(agent2, storage0)
    -hold(agent2, None)

-kitchen state:
    -inside(storage0, None)
    -inside(servingtable0, None)
    -inside(pot0, None)
    -inside(pot1, None)

-accomplished task:

In round 0, you thought: 
- agent0 said: We are making onionBroccoliCheeseSoup. I will get onion from storage0. Agent1 will get broccoli and agent2 will get cheese. After that, we need to put ingredients into pot0. After that, one will activate pot0 to make onionBroccoliCheeseSoup. Then, I will continue to get ingredients for onionPotatoCarrotSoup.
Other agents thoughts in round 0:
-agent1 said: We are making onionBroccoliCheeseSoup. I will get broccoli from storage0. Agent0 will get onion and agent2 will get cheese. After that, we need to put ingredients into pot0. After that, one will activate pot0 to make onionBroccoliCheeseSoup. Then, we will get ingredients for onionPotatoCarrotSoup.
-agent2 said: We decided to make onionBroccoliCheeseSoup first. I will get cheese from storage0. Agent0 will get onion and agent1 will get broccoli. After that, we need to put ingredients into pot0. After that, one will activate pot0 to make onionBroccoliCheeseSoup. Then, we will get ingredients for onionPotatoCarrotSoup.
Your next thought[write only the thought]:
"""),

("assistant",
"""
We agreed that I will get onion, agent1 will get broccoli, and agent2 will get cheese. After that, we need to put ingredients into pot0. After that, one can activate pot0, while the other start getting the ingredients for onionPotatoCarrotSoup in pot1.
"""),

("user", 
"""
In round 1, you thought: 
- agent0 said: We need to make as many dishes as possible. We start with onionBroccoliCheeseSoup as it has smaller lifetime value. We need to get onion, broccoli, and cheese from storage0. But we can only get 1 at a time. I can take onion, agent1 can take broccoli, and agent2 can take cheese. After that, we need to put onion, broccoli, and cheese into pot0. After that, one can activate pot0, while the other start getting the ingredients for onionPotatoCarrotSoup in pot1.
Other agents thought in round 1: 
- agent1 said: We are going to make onionBroccoliCheeseSoup first. As agent0 suggested, we can divide the tasks. I will get broccoli from storage0. Agent0 will get onion and agent2 will get cheese. After that, we need to put ingredionts into pot0. Then we need to activate pot0 to make onionBroccoliCheeseSoup. Finally, we need to put onionBroccoliCheeseSoup into servingtable0. 
- agent2 said: We are making onionBroccoliCheeseSoup. I will get cheese from storage0. Agent0 will get onion and agent1 will get broccoli. After that, we need to put ingredients into pot0. Then one will activate pot0 to make onionBroccoliCheeseSoup. Then, I will continue to get ingredients for onionPotatoCarrotSoup.
"""),

("assistant",
"""
We agreed that I will get onion, agent1 will get broccoli, and agent2 will get cheese. After that, we need to put ingredients into pot0. After that, one can activate pot0, while the other start getting the ingredients for onionPotatoCarrotSoup in pot1.
"""),

]