# orchestrator_info_prompt = """
# In this game, There are {total_num_agents} agents available, 
# so you should control all the {total_num_agents} agents, and plan {total_num_agents} actions at a time. \n"""

orchestrator_info_prompt = """In this game, there are {total_num_agents} agents available, so you should generate a plan for all the {total_num_agents} agents.
Your task is to generate a plan for all the agents given the state of the game.
Follow the return format from the example. Return only the action.
Every action from each model has a different use cost according to their success ratio, so you should consider the cost when generating the plan.
You have a total budget of ${budget}, and you should consider the allocation to minimize the cost.
idle action (noop) is free.
Cost: 
{costs}
"""


orchestrator_examples = [
("user", 
"""----- START OF EXAMPLE -----
There are 2 agents available. So you can execute 2 actions at a time.
This is an example you can use as a reference for a different level.

-execution error messages:
  --  []
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 10
current game step: 0
maximum game steps: 60

-agent state:
at(agent0, servingtable0)
hold(agent0, None)
at(agent1, servingtable0)
hold(agent1, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, None)
inside(mixer0, None)

-budget: $0/1000

-accomplished task:

-action:
"""),

("assistant",
"""goto_agent0_storage0
goto_agent1_storage0"""),

("user",
"""-execution error messages:
  --  []
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 9
current game step: 1
maximum game steps: 60

-agent state:
at(agent0, storage0)
hold(agent0, None)
at(agent1, storage0)
hold(agent1, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, None)
inside(mixer0, None)

-budget: $6/1000

-accomplished task:

-action: 
"""),

("assistant","""
get_agent0_tuna_storage0
get_agent1_tuna_storage0"""),

("user", """-execution error messages:
  --  []
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 8
current game step: 2
maximum game steps: 60

-agent state:
at(agent0, storage0)
hold(agent0, tuna)
at(agent1, storage0)
hold(agent1, tuna)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, None)
inside(mixer0, None)

-accomplished task:

-action:
"""),

("assistant","""
goto_agent0_chopboard0
goto_agent1_chopboard0
"""),

("user", """
-execution error messages:
  --  []
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 7
current game step: 3
maximum game steps: 60

-agent state:
at(agent0, chopboard0)
hold(agent0, tuna)
at(agent1, chopboard0)
hold(agent1, tuna)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, None)
inside(mixer0, None)
 
-budget: $14/1000

-accomplished task:

-action:
"""),

("assistant","""
put_agent0_tuna_chopboard0
put_agent1_tuna_chopboard0
"""),

("user", """-execution error messages:
  --  ['chopboard0 reaches maximum capacity']
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 6
current game step: 4
maximum game steps: 60

-agent state:
at(agent0, chopboard0)
hold(agent0, None)
at(agent1, chopboard0)
hold(agent1, tuna)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, tuna)
inside(mixer0, None)
 
-budget: $20/1000

-accomplished task:

-action:
"""),

("assistant","""activate_agent0_chopboard0
put_agent1_tuna_chopboard0
"""),

("user", """-execution error messages:
  --  ['chopboard0 is occupied, therefore cannot put objects into it', 'chopboard0 reaches maximum capacity']
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 5
current game step: 5
maximum game steps: 60

-agent state:
at(agent0, chopboard0)
hold(agent0, None)
at(agent1, chopboard0)
hold(agent1, tuna)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, tunaSashimi)
inside(mixer0, None)

-budget: $26/1000

-accomplished task:

-action:
"""),

("assistant","""get_agent0_tunaSashimi_chopboard0
goto_agent1_storage0
"""),

("user", """-execution error messages:
  --  []
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 4
current game step: 6
maximum game steps: 60

-agent state:
at(agent0, chopboard0)
hold(agent0, tunaSashimi)
at(agent1, storage0)
hold(agent1, tuna)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, None)
inside(mixer0, None)

-budget: $32/1000

-accomplished task:

-action:
"""),

("assistant","""goto_agent0_servingtable0
put_agent1_tuna_storage0"""),

("user", """-execution error messages:
  --  []
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 3
current game step: 7
maximum game steps: 60

-agent state:
at(agent0, servingtable0)
hold(agent0, tunaSashimi)
at(agent1, storage0)
hold(agent1, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, None)
inside(mixer0, None)
 
-budget: $40/1000
-accomplished task:

-action:
"""),

("assistant","""put_agent0_tunaSashimi_servingtable0
noop_agent1
"""),

("user", """-execution error messages:
  --  []
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
current game step: 8
maximum game steps: 60

-agent state:
at(agent0, servingtable0)
hold(agent0, None)
at(agent1, storage0)
hold(agent1, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, None)
inside(mixer0, None)

-budget: $44/1000

-accomplished task:
tunaSashimi, 

-action:
"""),

("assistant","""noop_agent0
noop_agent1
"""),

("user", """-execution error messages:
  --  ['None of the agents performed any actions which is not normal.']
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
current game step: 9
maximum game steps: 60

-agent state:
at(agent0, servingtable0)
hold(agent0, None)
at(agent1, storage0)
hold(agent1, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, None)
inside(mixer0, None)

-budget: $44/1000

-accomplished task:
tunaSashimi, 

-action:
"""),

("assistant","""goto_agent0_storage0
noop_agent1
"""),

("user","""-execution error messages:
  --  []
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 10
current game step: 10
maximum game steps: 60

-agent state:
at(agent0, storage0)
hold(agent0, None)
at(agent1, storage0)
hold(agent1, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, None)
inside(mixer0, None)
 
-budget: $48/1000

-accomplished task:
tunaSashimi, 

-action:
"""),

("assistant","""get_agent0_tuna_storage0
get_agent1_tuna_storage0"""),

("user", """-execution error messages:
  --  []
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 9
current game step: 11
maximum game steps: 60

-agent state:
at(agent0, storage0)
hold(agent0, tuna)
at(agent1, storage0)
hold(agent1, tuna)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, None)
inside(mixer0, None)

-budget: $55/1000

-accomplished task:
tunaSashimi, 

-action:
"""),

("assistant","""goto_agent0_chopboard0
goto_agent1_chopboard0"""),

("user", """-execution error messages:
  --  []
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 8
current game step: 12
maximum game steps: 60

-agent state:
at(agent0, chopboard0)
hold(agent0, tuna)
at(agent1, chopboard0)
hold(agent1, tuna)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, None)
inside(mixer0, None)

-budget: $64/1000

-accomplished task:
tunaSashimi, 

-action:
"""),

("assistant","""put_agent0_tuna_chopboard0
put_agent1_tuna_chopboard0"""),

("user", """-execution error messages:
  --  ['chopboard0 reaches maximum capacity']
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 7
current game step: 13
maximum game steps: 60

-agent state:
at(agent0, chopboard0)
hold(agent0, None)
at(agent1, chopboard0)
hold(agent1, tuna)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, tuna)
inside(mixer0, None)

-budget: $70/1000

-accomplished task:
tunaSashimi, 

-action:
"""),

("assistant","""activate_agent0_chopboard0
noop_agent1"""),

("user", """-execution error messages:
  --  []
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 6
current game step: 14
maximum game steps: 60

-agent state:
at(agent0, chopboard0)
hold(agent0, None)
at(agent1, chopboard0)
hold(agent1, tuna)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, tunaSashimi)
inside(mixer0, None)

-budget: $75/1000

-accomplished task:
tunaSashimi, 

-action:
"""),

("assistant",
"""get_agent0_tunaSashimi_chopboard0
noop_agent1"""
),

("user", """-execution error messages:
  --  []
-execution suggestions:
  --  []
-game state:
current game level: level_4
current dishes:
    name: tunaSashimi lifetime: 5
current game step: 15
maximum game steps: 60

-agent state:
at(agent0, chopboard0)
hold(agent0, tunaSashimi)
at(agent1, chopboard0)
hold(agent1, tuna)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(chopboard0, None)
inside(mixer0, None)

-budget: $80/1000

-accomplished task:
tunaSashimi, 

-action:"""),

("assistant",
"""goto_agent0_servingtable0
put_agent1_tuna_storage0"""
),
]