planner_info_prompt = """In this game, there are {total_num_agents} agents available, so you should generate a plan for all the {total_num_agents} agents.
Your task is to generate a plan for all the agents given the state of the game and their past performance.

Model Cost Information (per million tokens):
{model_costs}

Performance History:
{performance_history}

Guidelines for Adaptive Task Assignment:
1. Analyze each agent's success rate with different types of tasks (movement, item handling, cooking)
2. Assign tasks that match each agent's demonstrated strengths
3. If an agent consistently fails at a task type, try reassigning that task type to a different agent
4. For new task types, distribute evenly until performance data is available
5. Consider task complexity - assign simpler tasks to agents with lower success rates
6. Consider the cost of each agent's actions when making your plan, as each agent uses a different model with different costs

Current information about the kitchen environment:
- The layout of the kitchen and the position of all ingredients, cooking stations, and agents
- Any active dish orders, their requirements, and time limits
- The status of dishes in progress
- Any recently completed or canceled orders

Generate a CONCISE, one-paragraph plan that efficiently assigns tasks to all agents to complete the dishes.
Your plan should prioritize dishes based on time constraints, assign specific roles to each agent,
and coordinate agent movements to avoid inefficiencies.

Remember that your plan will be triggered at the start and whenever a dish is added, removed, or completed.
"""

planner_examples = [
    ("user", 
"""
----- START OF EXAMPLE -----
There are 2 agents available.

-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 17
current game step: 0
maximum game steps: 30

-agent state:
at(agent0, servingtable0)
hold(agent0, None)
at(agent1, servingtable0)
hold(agent1, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-performance history:
Agent0:
- Movement success rate: 95%
- Item pickup success rate: 85%
- Item placement success rate: 75%

Agent1:
- Movement success rate: 80%
- Item pickup success rate: 90%
- Item placement success rate: 85%

-budget: $0/1000

-accomplished task:

-plan:
"""),

("assistant",
 """
Based on the performance history, I'll assign tasks according to each agent's strengths:

1. **Initial Movement Phase:**
   - Agent0: goto_agent0_storage0 (high movement success rate)
   - Agent1: goto_agent1_storage0

2. **Item Collection Phase (planned):**
   - Agent1 will handle flour (high pickup success)
   - Agent0 will handle beef (decent pickup rate)

This plan leverages Agent0's superior movement ability for the initial phase while setting up Agent1 for item handling where they excel. I'll adjust the plan based on their performance in these initial steps.
"""),

("user", """
-previous actions:
 agent0: goto_agent0_storage0
 agent1: goto_agent1_storage0
 
-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 17
current game step: 0
maximum game steps: 30

-agent state:
at(agent0, storage0)
hold(agent0, None)
at(agent1, storage0)
hold(agent1, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-performance history:
Agent0:
- Movement success rate: 95%
- Item pickup success rate: 85%
- Item placement success rate: 75%

Agent1:
- Movement success rate: 80%
- Item pickup success rate: 90%
- Item placement success rate: 85%
 
-budget: $6/1000

-accomplished task:

-plan:

"""
 ),

 ("assistant", """Based on the performance history and current state:

**Get ingredients (optimized for pickup success):**
   - Agent1: get_agent1_flour_storage0 (90% pickup success rate)
   - Agent0: get_agent0_beef_storage0 (85% pickup success rate)

This assignment matches Agent1's higher item pickup success rate with the flour task, while Agent0 handles the beef. Both ingredients are equally important, but we're maximizing overall success probability by matching tasks to agent strengths.
"""),

("user", " ----- END OF EXAMPLE -----")

]


executor_info_prompt = """In this game, There are {total_num_agents} agents available, you are agent{agent_id} and you can only control and the actions for this agent. 
If you try to execute an action for different agent, it will cause an error.
You are given a plan for all the agents, and you should generate the action for the agent{agent_id}."""

executor_examples = [
("user", 
"""----- START OF EXAMPLE -----
There are 2 agents available. You are controlling agent0. You can execute 1 action at a time.
This is an example you can use as a reference for a different level.

-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 17
current game step: 0
maximum game steps: 30

-agent state:
at(agent0, servingtable0)
hold(agent0, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:

-plan:To start solving the problem, we need to get the base ingredients from the storage. Since all agents are initially at the servingtable, we'll need to move them to the storage first. Here's a plan for all 2 agents:

1. **Move agents to storage:**
   - Agent0: goto_agent0_storage0
   - Agent1: goto_agent1_storage0

This plan aims to get all agents to the storage location so they can start retrieving base ingredients (salmon, flour, pork) for cooking.

-action:
"""),

("assistant", "goto_agent0_storage0"),

("user", 
"""-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 17
current game step: 0
maximum game steps: 30

-agent state:
at(agent0, servingtable0)
hold(agent0, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:

-plan:As we are making the beefMeatcake, we need to get the base ingredients from the storage. Agents are now in the storage and need to get the ingredients: beef and flour.

 **Get ingredients:**
   - Agent0: get_agent0_beef_storage0
   - Agent1: get_agent1_flour_storage0

-action:
"""),

("assistant", "get_agent0_beef_storage0"),

("assistant", "----- END OF EXAMPLE -----"),
]