#!/bin/bash

# Run missing 2-agent levels
echo "Running missing 2-agent levels..."
n_agents=2
executor_models="gpt-4o-mini,meta-llama/Llama-3.1-70B-Instruct"

echo "Running level 7 with 2 agents..."
python my_agent/run.py -t planner -n "$n_agents" -l level_7 -m "gpt-4o-v2" -ex "$executor_models" -s 60
echo "Analyzing trajectory for level 7..."
python analyze_trajectory.py

echo "Running level 12 with 2 agents..."
python my_agent/run.py -t planner -n "$n_agents" -l level_12 -m "gpt-4o-v2" -ex "$executor_models" -s 60
echo "Analyzing trajectory for level 12..."
python analyze_trajectory.py

# Run missing 3-agent level
echo "Running missing 3-agent level..."
n_agents=3
executor_models="gpt-4o-mini,meta-llama/Llama-3.1-70B-Instruct,Qwen/Qwen2.5-32B-Instruct"

echo "Running level 5 with 3 agents..."
python my_agent/run.py -t planner -n "$n_agents" -l level_5 -m "gpt-4o-v2" -ex "$executor_models" -s 60
echo "Analyzing trajectory for level 5..."
python analyze_trajectory.py

echo "All missing levels completed!"

# Compare all runs
echo "Comparing all runs..."
python compare_runs.py

echo "Everything completed!"