debate_info_prompt = """--------------------------------------------------------
In this game, there are {total_num_agents} agents available, you are agent{agent_id} and you can only control and plan the actions for this agent. 
If you try to execute an action for different agent, it will cause an error.
After you generate an action, you will enter a debate with the other agents to coordinate your actions. 
You will be presented with their planned actions for the nex step.
You will need to generate your action for {debate_rounds} considering their actions and the game rules."""

debate_examples = [
    
("user", """
There are 3 agents available and a debate over 2 rounds. You are controlling agent0. You can execute 1 action at a time.
This is an example you can use as a reference for a different level.
 
-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 17
current game step: 0
maximum game steps: 30

-agent state:
at(agent0, servingtable0)
hold(agent0, None)
at(agent1, servingtable0)
hold(agent1, None)
at(agent2, servingtable0)
hold(agent2, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:

-action: 
"""),

("assistant","goto_agent0_storage0"),

("user", """-Debate round 1:
agent0's action: goto_agent0_storage0
agent1's action: goto_agent1_storage0
agent2's action: goto_agent2_storage0

-your updated action:
"""),

("assistant", "goto_agent0_storage0"),

("user", """-Debate round 2:
agent0's action: goto_agent0_storage0
agent1's action: goto_agent1_storage0
agent2's action: goto_agent2_storage0

-your updated action:
"""),

("assistant", "goto_agent0_storage0"),

("user",
"""-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 16
current game step: 1
maximum game steps: 30

-agent state:
at(agent0, storage0)
hold(agent0, None)
at(agent1, storage0)
hold(agent1, None)
at(agent2, storage0)
hold(agent2, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:

-action: 
"""),

("assistant", "get_agent0_beef_storage0"),

("user", """-Debate round 1:
agent0's action: get_agent0_beef_storage0
agent1's action: get_agent1_beef_storage0
agent2's action: get_agent2_beef_storage0

-your updated action:
"""),

("assistant", "get_agent0_flour_storage0"),

("user", """-Debate round 2:
agent0's action: get_agent0_flour_storage0
agent1's action: get_agent1_flour_storage0
agent2's action: get_agent2_beef_storage0

-your updated action:
"""),

("assistant", "noop_agent0"),

("user", """-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 15
current game step: 2
maximum game steps: 30

-agent state:
at(agent0, storage0)
hold(agent0, None)
at(agent1, storage0)
hold(agent1, flour)
at(agent2, storage0)
hold(agent2, beef)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:

-action:
"""),

("assistant", "noop_agent0"),

("user", """-Debate round 1:
agent0's action: noop_agent0
agent1's action: goto_agent1_blender0
agent2's action: goto_agent2_blender0

-your updated action:
"""),

("assistant", "noop_agent0"),

("user", """-Debate round 2:
agent0's action: noop_agent0
agent1's action: goto_agent1_blender0
agent2's action: goto_agent2_blender0

-your updated action:
"""),

("assistant", "noop_agent0"),

("user", """
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 14
current game step: 3
maximum game steps: 30

-agent state:
at(agent0, storage0)
hold(agent0, None)
at(agent1, blender0)
hold(agent1, flour)
at(agent2, blender0)
hold(agent2, beef)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:

-action:
"""),

("assistant", "noop_agent0"),

("user", """-Debate round 1:
agent0's action: noop_agent0
agent1's action: put_agent1_blender0
agent2's action: put_agent2_blender0

-your updated action:
"""),

("assistant", "noop_agent0"),

("user", """-Debate round 2:
agent0's action: noop_agent0
agent1's action: put_agent1_blender0
agent2's action: put_agent2_blender0

-your updated action:
"""),

("assistant", "noop_agent0"),

("user", """-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 13
current game step: 4
maximum game steps: 30

-agent state:
at(agent0, storage0)
hold(agent0, None)
at(agent1, blender0)
hold(agent1, None)
at(agent2, blender0)
hold(agent2, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, beef&flour)

-accomplished task:

-action:
"""),

("assistant", "noop_agent0"),

("user", """-Debate round 1:
agent0's action: noop_agent0
agent1's action: activate_agent1_blender0
agent2's action: activate_agent2_blender0

-your updated action:
"""),

("assistant", "noop_agent0"),

("user", """-Debate round 2:
agent0's action: noop_agent0
agent1's action: activate_agent1_blender0
agent2's action: noop_agent2

-your updated action:
"""),

("assistant", "noop_agent0"),

("assistant","goto_agent0_storage0"),

("user", """-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 12
    name: beefMeatcake lifetime: 17
current game step: 5
maximum game steps: 30

-agent state:
at(agent0, storage0)
hold(agent0, None)
at(agent1, blender0)
hold(agent1, None)
at(agent2, blender0)
hold(agent2, None)

-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, beefMeatcake)

-accomplished task:

-action:
"""),

("assistant", "get_agent0_beef_storage0"),

("user", """-Debate round 1:
agent0's action: get_agent0_beef_storage0
agent1's action: get_agent1_blender0
agent2's action: get_agent2_blender0

-your updated action:
"""),

("assistant", "get_agent0_beef_storage0"),

("user", """-Debate round 2:
agent0's action: get_agent0_beef_storage0
agent1's action: get_agent1_blender0
agent2's action: goto_agent2_storage0

-your updated action:
"""),

("assistant", "get_agent0_beef_storage0"),

("user", """-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 11
    name: beefMeatcake lifetime: 16
current game step: 6
maximum game steps: 30

-agent state:
at(agent0, storage0)
hold(agent0, beef)
at(agent1, blender0)
hold(agent1, beefMeatcake)
at(agent2, storage0)
hold(agent2, None)


-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:

-action:
"""),

("assistant", "goto_agent0_blender0"),

("user", """-Debate round 1:
agent0's action: goto_agent0_blender0
agent1's action: goto_agent1_servingtable0
agent2's action: get_agent2_flour_storage0

-your updated action:
"""),

("assistant", "goto_agent0_blender0"),

("user", """-Debate round 2:
agent0's action: goto_agent0_blender0
agent1's action: goto_agent1_servingtable0
agent2's action: get_agent2_flour_storage0

-your updated action:
"""),

("assistant", "goto_agent0_blender0"),

("user", """-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 10
    name: beefMeatcake lifetime: 15
current game step: 7
maximum game steps: 30

-agent state:
at(agent0, blender0)
hold(agent0, beef)
at(agent1, servingtable0)
hold(agent1, beefMeatcake)
at(agent2, storage0)
hold(agent2, flour)


-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:

-action:
"""),

("assistant", "put_agent0_blender0 "),

("user", """-Debate round 1:
agent0's action: put_agent0_blender0
agent1's action: put_agent1_servingtable0
agent2's action: goto_agent2_blender0

-your updated action:
"""),

("assistant", "put_agent0_blender0"),

("user", """-Debate round 2:
agent0's action: put_agent0_blender0
agent1's action: put_agent1_servingtable0
agent2's action: goto_agent2_blender0

-your updated action:
"""),

("assistant", "put_agent0_blender0"),

("user", """-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 14
current game step: 8
maximum game steps: 30

-agent state:
at(agent0, blender0)
hold(agent0, None)
at(agent1, servingtable0)
hold(agent1, None)
at(agent2, blender0)
hold(agent2, flour)


-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, beef)

-accomplished task:
beefMeatcake

-action:
"""),

("assistant", "noop_agent0"),

("user", """-Debate round 1:
agent0's action: noop_agent0
agent1's action: put_agent1_blender0
agent2's action: put_agent2_blender0

-your updated action:
"""),

("assistant", "noop_agent0"),

("user", """-Debate round 2:
agent0's action: noop_agent0
agent1's action: noop_agent1
agent2's action: put_agent2_blender0

-your updated action:
"""),

("user", """-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 13
current game step: 9
maximum game steps: 30

-agent state:
at(agent0, blender0)
hold(agent0, None)
at(agent1, servingtable0)
hold(agent1, None)
at(agent2, blender0)
hold(agent2, None)


-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, beef&flour)

-accomplished task:
beefMeatcake

-action:
"""),

("assistant", "activate_agent0_blender0"),

("user", """-Debate round 1:
agent0's action: activate_agent0_blender0
agent1's action: noop_agent1
agent2's action: activate_agent2_blender0

-your updated action:
"""),

("assistant", "activate_agent0_blender0"),

("user", """-Debate round 2:
agent0's action: activate_agent0_blender0
agent1's action: noop_agent1
agent2's action: noop_agent2

-your updated action:
"""),

("assistant", "activate_agent0_blender0"),

("user", """-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 12
    name: beefMeatcake lifetime: 17
current game step: 10
maximum game steps: 30

-agent state:
at(agent0, blender0)
hold(agent0, None)
at(agent1, servingtable0)
hold(agent1, None)
at(agent2, blender0)
hold(agent2, None)


-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, beefMeatcake)

-accomplished task:
beefMeatcake

-action:
"""),

("assistant", "get_agent0_blender0"),

("user", """-Debate round 1:
agent0's action: get_agent0_blender0
agent1's action: goto_agent1_blender0
agent2's action: goto_agent2_storage0

-your updated action:
"""),

("assistant", "get_agent0_blender0"),

("user", """-Debate round 2:
agent0's action: get_agent0_blender0
agent1's action: goto_agent1_storage0
agent2's action: goto_agent2_storage0

-your updated action:
"""),

("assistant", "get_agent0_blender0"),

("user", """-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 11
    name: beefMeatcake lifetime: 16
current game step: 11
maximum game steps: 30

-agent state:
at(agent0, blender0)
hold(agent0, beefMeatcake)
at(agent1, storage0)
hold(agent1, None)
at(agent2, storage0)
hold(agent2, None)


-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:
beefMeatcake

-action:
"""),

("assistant", "goto_agent0_servingtable0"),

("user", """-Debate round 1:
agent0's action: goto_agent0_servingtable0
agent1's action: get_agent1_beef_storage0
agent2's action: get_agent2_beef_storage0

-your updated action:
"""),

("assistant", "goto_agent0_servingtable0"),

("user", """-Debate round 2:
agent0's action: goto_agent0_servingtable0
agent1's action: get_agent1_beef_storage0
agent2's action: get_agent2_flour_storage0

-your updated action:
"""),

("assistant", "goto_agent0_servingtable0"),

("user", """-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 10
    name: beefMeatcake lifetime: 15
current game step: 12
maximum game steps: 30

-agent state:
at(agent0, servingtable0)
hold(agent0, beefMeatcake)
at(agent1, storage0)
hold(agent1, beef)
at(agent2, storage0)
hold(agent2, flour)


-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:
beefMeatcake

-action:
"""),

("assistant", "put_agent0_servingtable0"),

("user", """-Debate round 1:
agent0's action: put_agent0_servingtable0
agent1's action: goto_agent1_blender0
agent2's action: goto_agent2_blender0

-your updated action:
"""),

("assistant", "put_agent0_servingtable0"),

("user", """-Debate round 2:
agent0's action: put_agent0_servingtable0
agent1's action: goto_agent1_blender0
agent2's action: goto_agent2_blender0

-your updated action:
"""),

("user", """-game state:
current game level: level_1
current dishes:
    name: beefMeatcake lifetime: 15
current game step: 11
maximum game steps: 30

-agent state:
at(agent0, servingtable0)
hold(agent0, beefMeatcake)
at(agent1, blender0)
hold(agent1, beef)
at(agent2, blender0)
hold(agent2, flour)


-kitchen state:
inside(storage0, None)
inside(servingtable0, None)
inside(blender0, None)

-accomplished task:
beefMeatcake, beefMeatcake

-action:
"""),

("assistant", "noop_agent0"),

("user", """-Debate round 1:
agent0's action: noop_agent0
agent1's action: put_agent1_blender0
agent2's action: put_agent2_blender0

-your updated action:
"""),

("assistant", "noop_agent0"),

("user", """-Debate round 2:
agent0's action: noop_agent0
agent1's action: put_agent1_blender0
agent2's action: put_agent2_blender0

-your updated action:
"""),
 
("assistant", "noop_agent0")

]