The note is for our supplementarial material attached to our ICLR submission "An Empirical Exploration of Open-Set Recognition via Lightweight Statistical Pipelines". We provide the following Jupyter Notebook files, which serve more like a tutorial with visuals rather than executable scripts, due to the space limit that prevents us from uploading models and data. We are committed to releasing our models and scripts to the public after paper decision notification.

We refer readers to the Jupyter Notebook files for self-explanatory descriptions. Hereby we only briefly describe what these files present.

#### demo_open-set-semantic-segmentation.ipynb
This notebook file demonstrates open-set semantic segmentation using GMM and the baseline method MSP (max of softmax probability). It also includes some visualizations on how the two methods find the open-set pixels.


#### demo_Setup-II_Res50pt_L2norm_cGMM_pca.ipynb
This notebook file demonstrates the learning of GMMs for open-set image recognition under Setup-II, where we sample cross-dataset images as open-set data for val/test-sets. Specifically, we show how we train and tune GMMs, with PCA dimensionality reduction (from 2048-dim to 200-dim of features extracted from Res50). We L2-normalize the features in this experiment. We show a bunch of ROC curves on both val and test sets, demonstrating the performance on the val-set translates well to test-sets. 


#### demo_tsne_visual_res50pt.ipynb
This notebook illustrates t-SNE visualization of open- and closed-set images. This code is used in Section 4.2 of the main paper, where we sample cross-dataset images as the open-set. This notebook corresponds to Section 4.2 of the paper. From the visualization, we can intuitively see why statistical models work so well on the L2-normalized off-the-shelf features, and why logit features are not sufficient for open-set recognition.
