import numpy as np
import matplotlib.pyplot as plt

# Load the .npy file
actions = np.load("sfbc50.npy", allow_pickle=True)

# Extract x and y values from the matrix
x_values = actions[:, 0]
y_values = actions[:, 1]
print(x_values)
print(y_values)
# Create a plot using Matplotlib
plt.scatter(x_values, y_values, alpha=0.3, color="#d62728", label="SfBC", s=5.5)
plt.xlabel("action_x")
plt.ylabel("action_y")
plt.title("Plot of Loaded Data from .npy File")
plt.legend()
# plt.grid(True)
plt.savefig("sfbc.pdf", format="pdf")
plt.show()
