from playwright.sync_api import sync_playwright
import time

def expand_all_volumes():
    with sync_playwright() as p:
        # 启动浏览器
        browser = p.chromium.launch(headless=True)
        page = browser.new_page()
        
        # 访问页面
        page.goto("https://www.cell.com/developmental-cell/issues")
        
        # 等待页面加载
        page.wait_for_load_state("networkidle")
        
        # 等待volume展开按钮加载
        page.wait_for_selector(".list-of-issues__group-expand")
        
        # 找到所有volume展开按钮
        volume_buttons = page.locator(".list-of-issues__group-expand")
        count = volume_buttons.count()
        
        print(f"Found {count} volumes to expand")
        
        # 逐个点击展开
        for i in range(count):
            try:
                # 重新获取按钮以避免stale element
                button = page.locator(".list-of-issues__group-expand").nth(i)
                if button.is_visible():
                    button.click()
                    print(f"Expanded volume {i+1}/{count}")
                    # 等待内容加载
                    time.sleep(1)  # 增加等待时间确保内容加载完成
            except Exception as e:
                print(f"Error expanding volume {i+1}: {e}")
        
        # 等待所有内容加载完成
        page.wait_for_load_state("networkidle")
        
        # 获取完整HTML
        html = page.content()
        
        # 保存HTML
        with open("full_issues.html", "w", encoding="utf-8") as f:
            f.write(html)
            
        print("Saved complete HTML to full_issues.html")
        
        # 关闭浏览器
        browser.close()

if __name__ == "__main__":
    expand_all_volumes()