import os
import sys
sys.path.append(os.getcwd())
from utils.llm_call import CallLLM
from utils.parse_jsonString import parse_probabilities,parse_json_string

from utils.config_loader import ConfigLoader
from experiment.method.CoVR0 import story_extractor,description_extractor,reasoning_thinker
from concurrent.futures import ThreadPoolExecutor
import base64
class majority_voter():
    def __init__(self,model_name="qwen2.5-vl-7b-instruct"):
        self.llm = CallLLM(model=model_name)
    def majority_voting(self, messages:list)->tuple[list,int]:
        total_tokens = 0
        all_probs = []
        with ThreadPoolExecutor(max_workers=3) as executor:
            futures = [executor.submit(self.llm.post_request, messages) for _ in range(4)]
            results = [future.result() for future in futures]
        for result in results:
            try:
                prob = parse_probabilities(result[0])
                total_tokens += result[1]
                all_probs.append(prob)
            except Exception as e:
                print(f"Error: Failed to parse response for {e}")
                continue
        return all_probs, total_tokens

class answer_checker():
    def __init__(self,model_name="qwen2.5-vl-7b-instruct"):
        self.llm = CallLLM(model=model_name)

    def answer_checking(self, given_info, option, type:str='image2text'):
        if type == 'image2text':
            system_prompt = "You are a rigorous and experienced image inspector. For the option I provided, please carefully verify whether it completely aligns with the given information, and predict the probability of a complete match (True) versus an incomplete match (False). Answer AS SIMPLE AS POSSIBLE. Make sure the probabilities add up to 1.\n # Response Format\n ```json\n { \"True\": probability of choosing the True, \"False\": probability of choosing the False }\n```"

            user_prompt = f"The option is: {option}. You need to predict the probability that you would choose True or False. The given information is the following image."
            with open(given_info, 'rb') as image_file:
                image_base64 = base64.b64encode(image_file.read()).decode('utf-8')
            messages = [
                {"role": "system", "content": system_prompt},
                {"role": "user", "content": [
                    {
                        "type": "text",
                        "text": user_prompt
                    },
                    {
                        "type": "image_url",
                        "image_url": {
                            "url": f"data:image/png;base64,{image_base64}",
                            "detail": "auto"
                        }
                    }
                ]}
            ]
        elif type == 'text2image':
            system_prompt = "You are a rigorous and experienced text inspector. For the option I provided, please carefully verify whether it completely aligns with the given information, and predict the probability of a complete match (True) versus an incomplete match (False). Answer AS SIMPLE AS POSSIBLE. Make sure the probabilities add up to 1.\n # Response Format\n ```json\n { \"True\": probability of choosing the True, \"False\": probability of choosing the False }\n```"
            user_prompt = f"The given information is: {given_info}. You need to predict the probability that you would choose True or False. The option is the following image."
            with open(option, 'rb') as image_file:
                image_base64 = base64.b64encode(image_file.read()).decode('utf-8')
            messages = [
                {"role": "system", "content": system_prompt},
                {"role": "user", "content": [
                    {
                        "type": "text",
                        "text": user_prompt
                    },
                    {
                        "type": "image_url",
                        "image_url": {
                            "url": f"data:image/png;base64,{image_base64}",
                            "detail": "auto"
                        }
                    }
                ]}
            ]
        response, total_tokens = self.llm.post_request(messages)
        return response, total_tokens
    
    def check_2_options(self, given_info, options, type:str='image2text'):
        if type == 'image2text':
            system_prompt = "# Requirement\n You are an excellent scientific image reader. You need to analyze the provided image and choose the most appropriate option based on your understanding. ONLY based on the image and the options provided above, predict the probability that you would choose each option and answer AS SIMPLE AS POSSIBLE. Make sure the probabilities add up to 1.\n # Response Format\n ```json\n { \"A\": probability of choosing the option A, \"B\": probability of choosing the option B, \"C\": probability of choosing the option C, \"D\": probability of choosing the option D }\n```"

            user_prompt = f"I want to ask you the following question: Which of the following options best describe the cover image? And you have the following options: {options}. You need to predict the probability that you would choose each option based on the image."
            with open(given_info, 'rb') as image_file:
                image_base64 = base64.b64encode(image_file.read()).decode('utf-8')
            messages = [
                {"role": "system", "content": system_prompt},
                {"role": "user", "content": [
                    {
                        "type": "text",
                        "text": user_prompt
                    },
                    {
                        "type": "image_url",
                        "image_url": {
                            "url": f"data:image/png;base64,{image_base64}",
                            "detail": "auto"
                        }
                    }
                ]}
            ]
        elif type == 'text2image':
            pass
        response, total_tokens = self.llm.post_request(messages)
        return response, total_tokens


class CoVRr1():
    def __init__(self,mllm_model="qwen2.5-vl-7b-instruct"):
        self.mllm_agent = majority_voter(mllm_model)

    def post_request(self,question,given_info, options:list,messages:list,type:str='image2text'):
        """
        options形状为[('A', 'option_content_A'), ('B', 'option_content_B'), ('C', 'option_content_C'), ('D', 'option_content_D')]
        questions是为了接口统一
        """
        if type == 'image2text':
            return_options = '\n'.join([f'{option_id}: {option_content}' for option_id, option_content in options])
            try:
                vote_results, total_tokens = self.mllm_agent.majority_voting(messages)
                answers = [max(format_answer, key=format_answer.get) for format_answer in vote_results]
                # 统计每个选项的投票数
                vote_count = {option: answers.count(option) for option in ['A','B','C','D']}
                # 确定票数前二的选项和票数
                top_2 = sorted(vote_count.items(), key=lambda x: x[1], reverse=True)[:1]
                distribution = {option: vote_count[option]/4 for option in ['A','B','C','D']}
                return str(distribution), total_tokens, return_options
            except Exception as e:
                print(f"Error: Majority voting failed: {e}")
                return None,0,return_options
            # 找到第二轮check的option和content
            check_options = {}
            for opt_id,opt_content in options:
                if opt_id == top_2[0][0] or opt_id == top_2[1][0]:
                    check_options[opt_id] = opt_content
            check_options = '\n'.join([f'{opt_id}: {opt_content}' for opt_id,opt_content in check_options.items()])
            response, total_tokens = self.checker.check_2_options(given_info, check_options, type)

            return response, total_tokens, return_options+'\n check_options: '+check_options
            # if top_2[1][1] > 1:
            #     # 调用verification
            #     try:    
            #         option = None
            #         for op in options:
            #             if op[0] == top_2[0][0]:
            #                 option = op[1]
            #                 break
            #         verification_results,check_token = self.checker.answer_checking(given_info, option, type)
            #         parsed_results = parse_json_string(verification_results,['True','False'])
            #         check_result = parsed_results['True'] > parsed_results['False']
                    

class CoVRr2():
    def __init__(self,mllm_model="qwen2.5-vl-7b-instruct",reasoning_model="qwq-32b"):
        self.mllm_agent = majority_voter(mllm_model)
        self.checker = answer_checker(mllm_model)
        self.story_extractor = story_extractor(reasoning_model)

    def post_request(self,question,given_info, options:list,messages:list,type:str='image2text'):
        """
        options形状为[('A', 'option_content_A'), ('B', 'option_content_B'), ('C', 'option_content_C'), ('D', 'option_content_D')]
        questions是为了接口统一
        """
        if type == 'image2text':
            return_options = '\n'.join([f'{option_id}: {option_content}' for option_id, option_content in options])
            try:
                vote_results, total_tokens = self.mllm_agent.majority_voting(messages)
                answers = [max(format_answer, key=format_answer.get) for format_answer in vote_results]
                # 统计每个选项的投票数
                vote_count = {option: answers.count(option) for option in ['A','B','C','D']}
                # 确定票数前二的选项和票数
                top_2 = sorted(vote_count.items(), key=lambda x: x[1], reverse=True)[:2]
            except Exception as e:
                print(f"Error: Majority voting failed: {e}")
                return None,0
            # 找到第二轮check的option和content
            check_options = {}
            for opt_id,opt_content in options:
                if opt_id == top_2[0][0] or opt_id == top_2[1][0]:
                    check_options[opt_id] = opt_content
            check_options = '\n'.join([f'{opt_id}: {opt_content}' for opt_id,opt_content in check_options.items()])
            new_options,tokens2 = self.story_extractor.extract_stories(check_options)
            parsed_new_options = parse_json_string(new_options)
            check_2options = {}
            for option_id,option_content in parsed_new_options.items():
                if option_id==top_2[0][0] or option_id==top_2[1][0]:
                    check_2options[option_id] = option_content
            check_2options_str = '\n'.join([f'{opt_id}: {opt_content}' for opt_id,opt_content in check_2options.items()])
            response, total_tokens2 = self.checker.check_2_options(given_info, check_2options_str, type)

            return response, total_tokens+total_tokens2+tokens2, return_options+'\n new_options: '+check_2options_str         
            
class CoVRr4():
    def __init__(self,mllm_model="qwen2.5-vl-7b-instruct", reasoning_model="qwq-32b"):
        self.majority_voter = majority_voter(mllm_model)
        self.description_agent = description_extractor(mllm_model)
        self.reasoning_agent = reasoning_thinker(reasoning_model)
    def post_request(self,question, given_info, options:list,messages:list,type:str='image2text'):
        if type == 'image2text':
            return_options = '\n'.join([f'{option_id}: {option_content}' for option_id, option_content in options])
            vote_results, total_tokens = self.majority_voter.majority_voting(messages)
            answers = [max(format_answer, key=format_answer.get) for format_answer in vote_results]
            # 统计每个选项的投票数
            vote_count = {option: answers.count(option) for option in ['A','B','C','D']}
            # 确定票数前二的选项和票数
            top_2 = sorted(vote_count.items(), key=lambda x: x[1], reverse=True)[:2]
            top2_options = {}
            for opt_id,opt_content in options:
                if opt_id == top_2[0][0] or opt_id == top_2[1][0]:
                    top2_options[opt_id] = opt_content
            top2_options = '\n'.join([f'{opt_id}: {opt_content}' for opt_id,opt_content in top2_options.items()])
            description, tokens1 = self.description_agent.extract_description(given_info, question, top2_options)
            response, total_tokens2 = self.reasoning_agent.reasoning_thinking(description, top2_options)
            return response, total_tokens+total_tokens2+tokens1, return_options+'\n top2_options: '+top2_options+'\ndescription: '+description


if __name__ == "__main__": 
    mllm_agent = majority_voter()
    messages = [{'role': 'system', 'content': '# Requirement\n You are an excellent scientific image reader. You need to analyze the provided image and choose the most appropriate option based on your understanding. ONLY based on the image and the options provided above, predict the probability that you would choose each option and answer AS SIMPLE AS POSSIBLE. Make sure the probabilities add up to 1.\n # Response Format\n ```json\n { "A": probability of choosing the option A, "B": probability of choosing the option B, "C": probability of choosing the option C, "D": probability of choosing the option D }\n```'},{
        "role":"user","content":[{'type': 'text', 'text': 'I want to ask you the following question: Which of the following options best describe the cover image? And you have the following options: A: MicroLED chips align to shine\nMicro-light-emitting-diode (microLED) chips can be accurately aligned on a substrate — and used to create active-matrix displays — by engineering the top and bottom faces of the chips so that they have a different van der Waals interaction with the substrate. The optical microscopy image on the cover shows the microLED chips on a silicon substrate, with the faces of the chips all aligned in the same direction.\nSee Hwang et al. and News & Views by Do et al.\nImage: Kyungwook Hwang, SAIT. Cover design: Lauren Heslop.\nB: Self-healing whatever the weather\nA conductive skin-like material, which is composed of an elastomer and an ionic liquid, can self-heal in both wet and dry conditions due to reversible ion–dipole interactions. The cover shows a photograph of an ionic circuit board, with embedded light-emitting diodes, made from the transparent material.\nSee Cao et al. and News & Views by Majidi\nImage: Benjamin C.K. Tee and Wangwei Lee, National University of Singapore. Cover Design: Allen Beattie.\nC: Artificial neural networks in 2D\nMultilayers of the two-dimensional material hexagonal boron nitride (h-BN) can be employed as the resistive switching material in high-density memristive crossbar arrays, creating devices that can be used to model an artificial neural network for image recognition. The cover shows an optical microscopy image of a 10 × 10 memristor crossbar array, which has a vertical metal/h-BN/metal structure.\nSee Chen et al.\nImage: Mario Lanza, Soochow University. Cover Design: Tulsi Voralia.\nD: Electronic skins lead the way\nAn electronic-skin compass, which is fabricated on 6-μm-thick polymeric foils and accommodates magnetic field sensors based on the anisotropic magnetoresistance effect, allows a person to orient with respect to Earth’s magnetic field and to manipulate objects in virtual reality. The cover shows a scanning electron microscopy image of the compass under a bending radius of 200 μm.\nSee Makarov et al. and News & Views by Heidari\nImage: Gilbert Santiago Cañón Bermúdez, Helmholtz-Zentrum Dresden Rossendorf e.V. Cover Design: Allen Beattie.. You need to predict the probability that you would choose each option based on the image.'}]
    }
    ]
    print(mllm_agent.majority_voting(messages))
    # mllm_agent.extract_description("experiment/method/test2.png")